/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.rundata;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ecs.Document;
import org.apache.ecs.Element;
import org.apache.ecs.StringElement;
import org.apache.turbine.Turbine;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.mimetype.TurbineMimeTypes;
import org.apache.turbine.services.rundata.TurbineRunData;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.FormMessages;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.SystemError;
import org.apache.turbine.util.parser.CookieParser;
import org.apache.turbine.util.parser.ParameterParser;
import org.apache.turbine.util.pool.RecyclableSupport;
import org.apache.turbine.util.security.AccessControlList;
import org.apache.turbine.util.template.TemplateInfo;

public class DefaultTurbineRunData
extends RecyclableSupport
implements TurbineRunData {
    private static Locale defaultLocale = null;
    private static String defaultCharSet = null;
    private ParameterParser parameters;
    public CookieParser cookies;
    private HttpServletRequest req;
    private HttpServletResponse res;
    private ServletConfig config;
    private ServletContext servletContext;
    private AccessControlList acl;
    private boolean pageSet;
    private Document page;
    private String action;
    private String layout;
    private String screen;
    private String templateEncoding;
    private TemplateInfo templateInfo;
    private StringElement message;
    private FormMessages messages;
    private User user;
    private String title;
    private boolean outSet;
    private PrintWriter out;
    private Locale locale;
    private String charSet;
    private String contentType = "text/html";
    private String redirectURI;
    private int statusCode = 200;
    private List errors = new ArrayList();
    private Map jndiContexts;
    private ServerData serverData;
    private String remoteAddr;
    private String remoteHost;
    private String userAgent;
    private String stackTrace;
    private Throwable stackTraceException;
    private Map debugVariables = new HashMap();
    private static Log log = LogFactory.getLog((Class)DefaultTurbineRunData.class);

    public static User getUserFromSession(HttpSession session) {
        try {
            return (User)session.getAttribute("turbine.user");
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public static boolean removeUserFromSession(HttpSession session) {
        try {
            session.removeAttribute("turbine.user");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected static Locale getDefaultLocale() {
        if (defaultLocale == null) {
            String lang = Turbine.getConfiguration().getString("locale.default.language", "en");
            String country = Turbine.getConfiguration().getString("locale.default.country", "US");
            defaultLocale = new Locale(lang, country);
        }
        return defaultLocale;
    }

    protected String getDefaultCharSet() {
        String charset;
        log.debug((Object)"getDefaultCharSet()");
        if (defaultCharSet == null) {
            defaultCharSet = Turbine.getConfiguration().getString("locale.default.charset", "ISO-8859-1");
            log.debug((Object)("defaultCharSet = " + defaultCharSet + " (From Properties)"));
        }
        if (StringUtils.isEmpty((String)(charset = defaultCharSet))) {
            log.debug((Object)"charset is empty!");
            Locale locale = this.locale;
            if (locale == null) {
                locale = DefaultTurbineRunData.getDefaultLocale();
                log.debug((Object)("Locale was null, is now " + locale + " (from getDefaultLocale())"));
            }
            log.debug((Object)("Locale is " + locale));
            if (!locale.equals(Locale.US)) {
                log.debug((Object)"We have US Locale!");
                charset = TurbineMimeTypes.getCharSet(locale);
                log.debug((Object)("Charset now " + charset));
            }
        }
        log.debug((Object)("Returning default Charset of " + charset));
        return charset;
    }

    public void recycle() {
        super.recycle();
    }

    public void dispose() {
        this.parameters = null;
        this.cookies = null;
        this.req = null;
        this.res = null;
        this.config = null;
        this.servletContext = null;
        this.acl = null;
        this.pageSet = false;
        this.page = null;
        this.action = null;
        this.layout = null;
        this.screen = null;
        this.templateEncoding = null;
        this.templateInfo = null;
        this.message = null;
        this.messages = null;
        this.user = null;
        this.title = null;
        this.outSet = false;
        this.out = null;
        this.locale = null;
        this.charSet = null;
        this.contentType = "text/html";
        this.redirectURI = null;
        this.statusCode = 200;
        this.errors.clear();
        this.jndiContexts = null;
        this.serverData = null;
        this.remoteAddr = null;
        this.remoteHost = null;
        this.userAgent = null;
        this.stackTrace = null;
        this.stackTraceException = null;
        this.debugVariables.clear();
        super.dispose();
    }

    public ParameterParser getParameters() {
        if (this.parameters != null && this.parameters.getRequest() != this.req) {
            this.parameters.setRequest(this.req);
        }
        return this.parameters;
    }

    public CookieParser getCookies() {
        if (this.cookies != null && this.cookies.getRequest() != this.getRequest()) {
            this.cookies.setRunData(this);
        }
        return this.cookies;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public HttpSession getSession() {
        return this.getRequest().getSession();
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public AccessControlList getACL() {
        return this.acl;
    }

    public void setACL(AccessControlList acl) {
        this.acl = acl;
    }

    public boolean isPageSet() {
        return this.pageSet;
    }

    public Document getPage() {
        this.pageSet = true;
        if (this.page == null) {
            this.page = new Document();
        }
        return this.page;
    }

    public boolean hasAction() {
        return StringUtils.isNotEmpty((String)this.action) && !this.action.equalsIgnoreCase("null");
    }

    public String getAction() {
        return this.hasAction() ? this.action : "";
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getLayout() {
        if (this.layout == null) {
            this.layout = TurbineTemplate.getDefaultLayoutName(this);
            if (this.layout == null) {
                this.layout = "DefaultLayout";
            }
        }
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getLayoutTemplate() {
        return this.getTemplateInfo().getLayoutTemplate();
    }

    public void setLayoutTemplate(String layout) {
        this.getTemplateInfo().setLayoutTemplate(layout);
    }

    public boolean hasScreen() {
        return StringUtils.isNotEmpty((String)this.screen);
    }

    public String getScreen() {
        return this.hasScreen() ? this.screen : "";
    }

    public void setScreen(String screen) {
        this.screen = screen;
    }

    public String getScreenTemplate() {
        return this.getTemplateInfo().getScreenTemplate();
    }

    public void setScreenTemplate(String screen) {
        this.getTemplateInfo().setScreenTemplate(screen);
    }

    public String getTemplateEncoding() {
        return this.templateEncoding;
    }

    public void setTemplateEncoding(String encoding) {
        this.templateEncoding = encoding;
    }

    public TemplateInfo getTemplateInfo() {
        if (this.templateInfo == null) {
            this.templateInfo = new TemplateInfo(this);
        }
        return this.templateInfo;
    }

    public boolean hasMessage() {
        return this.message != null && StringUtils.isNotEmpty((String)this.message.toString());
    }

    public String getMessage() {
        return this.message == null ? null : this.message.toString();
    }

    public void setMessage(String msg) {
        this.message = new StringElement(msg);
    }

    public void addMessage(String msg) {
        this.addMessage((Element)new StringElement(msg));
    }

    public StringElement getMessageAsHTML() {
        return this.message;
    }

    public void setMessage(Element msg) {
        this.message = new StringElement(msg);
    }

    public void addMessage(Element msg) {
        if (msg != null) {
            if (this.message != null) {
                this.message.addElement(msg);
            } else {
                this.message = new StringElement(msg);
            }
        }
    }

    public void unsetMessage() {
        this.message = null;
    }

    public FormMessages getMessages() {
        if (this.messages == null) {
            this.messages = new FormMessages();
        }
        return this.messages;
    }

    public void setMessages(FormMessages msgs) {
        this.messages = msgs;
    }

    public String getTitle() {
        return this.title == null ? "" : this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean userExists() {
        this.user = this.getUserFromSession();
        return this.user != null;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        log.debug((Object)("user set: " + user.getName()));
        this.user = user;
    }

    public User getUserFromSession() {
        return DefaultTurbineRunData.getUserFromSession(this.getSession());
    }

    public boolean removeUserFromSession() {
        return DefaultTurbineRunData.removeUserFromSession(this.getSession());
    }

    public boolean isOutSet() {
        return this.outSet;
    }

    public PrintWriter getOut() throws IOException {
        if (this.out == null) {
            this.setOut(this.res.getWriter());
        }
        this.pageSet = false;
        this.outSet = true;
        return this.out;
    }

    public void declareDirectResponse() {
        this.outSet = true;
        this.pageSet = false;
    }

    public Locale getLocale() {
        Locale locale = this.locale;
        if (locale == null) {
            locale = DefaultTurbineRunData.getDefaultLocale();
        }
        return locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        if (this.parameters != null) {
            this.parameters.setLocale(locale);
        }
        if (this.cookies != null) {
            this.cookies.setLocale(locale);
        }
    }

    public String getCharSet() {
        log.debug((Object)"getCharSet()");
        if (StringUtils.isEmpty((String)this.charSet)) {
            log.debug((Object)"Charset was null!");
            return this.getDefaultCharSet();
        }
        return this.charSet;
    }

    public void setCharSet(String charSet) {
        log.debug((Object)("setCharSet(" + charSet + ")"));
        this.charSet = charSet;
    }

    public String getContentType() {
        if (StringUtils.isNotEmpty((String)this.contentType)) {
            if (StringUtils.isEmpty((String)this.charSet)) {
                if (this.contentType.startsWith("text/")) {
                    return this.contentType + "; charset=" + this.getDefaultCharSet();
                }
            } else {
                return this.contentType + "; charset=" + this.charSet;
            }
        }
        return "";
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getRedirectURI() {
        return this.redirectURI == null ? "" : this.redirectURI;
    }

    public void setRedirectURI(String ruri) {
        this.redirectURI = ruri;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public SystemError[] getSystemErrors() {
        SystemError[] result = new SystemError[this.errors.size()];
        this.errors.toArray(result);
        return result;
    }

    public void setSystemError(SystemError err) {
        this.errors.add(err);
    }

    public Map getJNDIContexts() {
        if (this.jndiContexts == null) {
            this.jndiContexts = new HashMap();
        }
        return this.jndiContexts;
    }

    public void setJNDIContexts(Map contexts) {
        this.jndiContexts = contexts;
    }

    public String getServerScheme() {
        return this.getServerData().getServerScheme();
    }

    public String getServerName() {
        return this.getServerData().getServerName();
    }

    public int getServerPort() {
        return this.getServerData().getServerPort();
    }

    public String getContextPath() {
        return this.getServerData().getContextPath();
    }

    public String getScriptName() {
        return this.getServerData().getScriptName();
    }

    public ServerData getServerData() {
        return this.serverData;
    }

    public String getRemoteAddr() {
        if (this.remoteAddr == null) {
            this.remoteAddr = this.getRequest().getRemoteAddr();
        }
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.remoteHost = this.getRequest().getRemoteHost();
        }
        return this.remoteHost;
    }

    public String getUserAgent() {
        if (StringUtils.isEmpty((String)this.userAgent)) {
            this.userAgent = this.getRequest().getHeader("User-Agent");
        }
        return this.userAgent;
    }

    public void populate() {
        this.user = this.getUserFromSession();
        if (this.user != null) {
            this.user.setLastAccessDate();
            this.user.incrementAccessCounter();
            this.user.incrementAccessCounterForSession();
        }
    }

    public void save() {
        this.getSession().setAttribute("turbine.user", (Object)this.user);
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Throwable getStackTraceException() {
        return this.stackTraceException;
    }

    public void setStackTrace(String trace, Throwable exp) {
        this.stackTrace = trace;
        this.stackTraceException = exp;
    }

    public Map getVarDebug() {
        return this.debugVariables;
    }

    public void setDebugVariable(String name, Object value) {
        this.debugVariables.put(name, value);
    }

    public Map getDebugVariables() {
        return this.debugVariables;
    }

    public ParameterParser getParameterParser() {
        return this.parameters;
    }

    public void setParameterParser(ParameterParser parser) {
        this.parameters = parser;
    }

    public CookieParser getCookieParser() {
        return this.cookies;
    }

    public void setCookieParser(CookieParser parser) {
        this.cookies = parser;
    }

    public void setRequest(HttpServletRequest req) {
        this.req = req;
    }

    public void setResponse(HttpServletResponse res) {
        this.res = res;
    }

    public void setSession(HttpSession sess) {
    }

    public void setServletConfig(ServletConfig config) {
        this.config = config;
        this.servletContext = config == null ? null : config.getServletContext();
    }

    public void setServerData(ServerData serverData) {
        this.serverData = serverData;
    }

    protected void setOut(PrintWriter out) {
        this.out = out;
    }

    protected void setServerScheme(String serverScheme) {
        this.getServerData().setServerScheme(serverScheme);
    }

    protected void setServerName(String serverName) {
        this.getServerData().setServerName(serverName);
    }

    protected void setServerPort(int port) {
        this.getServerData().setServerPort(port);
    }

    protected void setContextPath(String contextPath) {
        this.getServerData().setContextPath(contextPath);
    }

    protected void setScriptName(String scriptName) {
        this.getServerData().setScriptName(scriptName);
    }
}

