/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security.torque;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.TorqueException;
import org.apache.torque.om.Persistent;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.services.security.torque.RolePeerManagerConstants;
import org.apache.turbine.services.security.torque.TorqueRole;
import org.apache.turbine.services.security.torque.UserPeerManager;
import org.apache.turbine.services.security.torque.om.TurbineUserGroupRolePeer;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.RoleSet;

public class RolePeerManager
implements RolePeerManagerConstants {
    private static Class rolePeerClass = null;
    private static Class roleObject = null;
    private static String tableName = null;
    private static String nameColumn = null;
    private static String idColumn = null;
    private static PropertyDescriptor namePropDesc = null;
    private static PropertyDescriptor idPropDesc = null;
    static Log log = LogFactory.getLog((Class)RolePeerManager.class);

    public static void init(Configuration conf) throws InitializationException {
        block6: {
            String rolePeerClassName = conf.getString("torque.rolePeer.class", ROLE_PEER_CLASS_DEFAULT);
            String roleObjectName = null;
            try {
                rolePeerClass = Class.forName(rolePeerClassName);
                tableName = (String)rolePeerClass.getField("TABLE_NAME").get(null);
                roleObject = RolePeerManager.getPersistenceClass();
                roleObjectName = conf.getString("torque.role.class", roleObject.getName());
                roleObject = Class.forName(roleObjectName);
                nameColumn = (String)rolePeerClass.getField(conf.getString("torque.rolePeer.column.name", "ROLE_NAME")).get(null);
                idColumn = (String)rolePeerClass.getField(conf.getString("torque.rolePeer.column.id", "ROLE_ID")).get(null);
                namePropDesc = new PropertyDescriptor(conf.getString("torque.role.property.name", "Name"), roleObject);
                idPropDesc = new PropertyDescriptor(conf.getString("torque.role.property.id", "RoleId"), roleObject);
            }
            catch (Exception e) {
                if (rolePeerClassName == null || rolePeerClass == null) {
                    throw new InitializationException("Could not find RolePeer class (" + rolePeerClassName + ")", e);
                }
                if (tableName == null) {
                    throw new InitializationException("Failed to get the table name from the Peer object", e);
                }
                if (roleObject == null || roleObjectName == null) {
                    throw new InitializationException("Failed to get the object type from the Peer object", e);
                }
                if (nameColumn == null || namePropDesc == null) {
                    throw new InitializationException("RolePeer " + rolePeerClassName + " has no name column information!", e);
                }
                if (idColumn != null && idPropDesc != null) break block6;
                throw new InitializationException("RolePeer " + rolePeerClassName + " has no id column information!", e);
            }
        }
    }

    public static String getTableName() {
        return tableName;
    }

    public static String getNameColumn() {
        return nameColumn;
    }

    public static String getIdColumn() {
        return idColumn;
    }

    public static String getColumnName(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append(RolePeerManager.getTableName());
        sb.append(".");
        sb.append(name);
        return sb.toString();
    }

    public static Persistent newPersistentInstance() {
        Persistent obj = null;
        if (roleObject == null) {
            return obj;
        }
        try {
            obj = (Persistent)roleObject.newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Could not instantiate a role object", (Throwable)e);
            obj = null;
        }
        return obj;
    }

    public static RoleSet retrieveSet(Criteria criteria) throws Exception {
        List results = RolePeerManager.doSelect(criteria);
        RoleSet rs = new RoleSet();
        Iterator it = results.iterator();
        while (it.hasNext()) {
            rs.add((Role)it.next());
        }
        return rs;
    }

    public static RoleSet retrieveSet(User user, Group group) throws Exception {
        Criteria criteria = new Criteria();
        criteria.add(UserPeerManager.getNameColumn(), (Object)user.getName());
        criteria.add(TurbineUserGroupRolePeer.GROUP_ID, (Object)((Persistent)group).getPrimaryKey());
        criteria.addJoin(UserPeerManager.getIdColumn(), TurbineUserGroupRolePeer.USER_ID);
        criteria.addJoin(TurbineUserGroupRolePeer.ROLE_ID, RolePeerManager.getIdColumn());
        return RolePeerManager.retrieveSet(criteria);
    }

    public static boolean checkExists(Role role) throws DataBackendException, Exception {
        Criteria criteria = new Criteria();
        criteria.addSelectColumn(RolePeerManager.getIdColumn());
        criteria.add(RolePeerManager.getNameColumn(), (Object)role.getName());
        List results = BasePeer.doSelect((Criteria)criteria);
        if (results.size() > 1) {
            throw new DataBackendException("Multiple roles named '" + role.getName() + "' exist!");
        }
        return results.size() == 1;
    }

    public static Criteria buildCriteria(Role role) {
        Criteria crit;
        try {
            Class[] clazz = new Class[]{roleObject};
            Object[] params = new Object[]{((TorqueRole)role).getPersistentObj()};
            crit = (Criteria)rolePeerClass.getMethod("buildCriteria", clazz).invoke(null, params);
        }
        catch (Exception e) {
            crit = null;
        }
        return crit;
    }

    public static void doUpdate(Criteria criteria) throws TorqueException {
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            rolePeerClass.getMethod("doUpdate", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doUpdate failed", (Throwable)e);
        }
    }

    public static void doInsert(Criteria criteria) throws TorqueException {
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            rolePeerClass.getMethod("doInsert", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doInsert failed", (Throwable)e);
        }
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        List list;
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            list = (List)rolePeerClass.getMethod("doSelect", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doSelect failed", (Throwable)e);
        }
        ArrayList<Role> newList = new ArrayList<Role>(list.size());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Role r = RolePeerManager.getNewRole((Persistent)it.next());
            newList.add(r);
        }
        return newList;
    }

    public static void doDelete(Criteria criteria) throws TorqueException {
        try {
            Class[] clazz = new Class[]{Criteria.class};
            Object[] params = new Object[]{criteria};
            rolePeerClass.getMethod("doDelete", clazz).invoke(null, params);
        }
        catch (Exception e) {
            throw new TorqueException("doDelete failed", (Throwable)e);
        }
    }

    public static void setRoleName(Persistent obj, String name) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{name};
            namePropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be a Role Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static String getRoleName(Persistent obj) {
        String name = null;
        if (obj == null) {
            return null;
        }
        try {
            name = (String)namePropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be a Role Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return name;
    }

    public static void setId(Persistent obj, int id) {
        if (obj == null) {
            return;
        }
        try {
            Object[] params = new Object[]{Integer.TYPE};
            idPropDesc.getWriteMethod().invoke((Object)obj, params);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be a Role Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public static Integer getIdAsObj(Persistent obj) {
        Integer id = null;
        if (obj == null) {
            return new Integer(0);
        }
        try {
            id = (Integer)idPropDesc.getReadMethod().invoke((Object)obj, new Object[0]);
        }
        catch (ClassCastException cce) {
            String msg = obj.getClass().getName() + " does not seem to be a Role Object!";
            log.error((Object)msg);
            throw new RuntimeException(msg);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
        return id;
    }

    private static Class getPersistenceClass() {
        Class persistenceClass = null;
        try {
            Object[] params = new Object[]{};
            persistenceClass = (Class)rolePeerClass.getMethod("getOMClass", null).invoke(null, params);
        }
        catch (Exception e) {
            persistenceClass = null;
        }
        return persistenceClass;
    }

    public static Role getNewRole(Persistent p) {
        Role r = null;
        try {
            Class roleWrapperClass = TurbineSecurity.getRoleClass();
            Class[] clazz = new Class[]{Persistent.class};
            Object[] params = new Object[]{p};
            r = (Role)roleWrapperClass.getConstructor(clazz).newInstance(params);
        }
        catch (Exception e) {
            log.error((Object)"Could not instantiate a new role from supplied persistent: ", (Throwable)e);
        }
        return r;
    }
}

