/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.parser;

import [Ljava.lang.Integer;;
import [Ljava.lang.String;;
import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.StringKey;
import org.apache.turbine.util.parser.ParserUtils;
import org.apache.turbine.util.parser.ValueParser;
import org.apache.turbine.util.pool.RecyclableSupport;

public class BaseValueParser
extends RecyclableSupport
implements ValueParser {
    private static Log log = LogFactory.getLog((Class)BaseValueParser.class);
    private static String[] trueValues = new String[]{"TRUE", "T", "YES", "Y", "1", "ON"};
    private static String[] falseValues = new String[]{"FALSE", "F", "NO", "N", "0", "OFF"};
    private Map parameters = new HashMap();
    private String characterEncoding = "ISO-8859-1";
    private Locale locale = Locale.getDefault();
    private DateFormat dateFormat = DateFormat.getDateInstance(3, this.locale);
    private NumberFormat numberFormat = NumberFormat.getNumberInstance(this.locale);

    public static String convertAndTrim(String value) {
        return ParserUtils.convertAndTrim(value);
    }

    public BaseValueParser() {
        this("ISO-8859-1");
    }

    public BaseValueParser(String characterEncoding) {
        this(characterEncoding, Locale.getDefault());
    }

    public BaseValueParser(String characterEncoding, Locale locale) {
        this.setCharacterEncoding(characterEncoding);
        this.setLocale(locale);
    }

    public void recycle(String characterEncoding) {
        this.setCharacterEncoding(characterEncoding);
        super.recycle();
    }

    public void dispose() {
        this.clear();
        super.dispose();
    }

    public void clear() {
        this.parameters.clear();
    }

    public void setCharacterEncoding(String s) {
        this.characterEncoding = s;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setLocale(Locale l) {
        this.locale = l;
        this.setDateFormat(DateFormat.getDateInstance(3, this.locale));
        this.setNumberFormat(NumberFormat.getNumberInstance(this.locale));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setDateFormat(DateFormat df) {
        this.dateFormat = df;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setNumberFormat(NumberFormat nf) {
        this.numberFormat = nf;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void add(String name, double value) {
        this.add(name, this.numberFormat.format(value));
    }

    public void add(String name, int value) {
        this.add(name, (long)value);
    }

    public void add(String name, Integer value) {
        if (value != null) {
            this.add(name, (int)value);
        }
    }

    public void add(String name, long value) {
        this.add(name, Long.toString(value));
    }

    public void add(String name, String value) {
        if (value != null) {
            Object[] items = this.getParam(name);
            items = (String[])ArrayUtils.add((Object[])items, (Object)value);
            this.putParam(name, (String[])items);
        }
    }

    public void add(String name, String[] value) {
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                if (value[i] == null) continue;
                this.add(name, value[i]);
            }
        }
    }

    public void append(String name, String value) {
        this.add(name, value);
    }

    public Object remove(String name) {
        return this.parameters.remove(this.convert(name));
    }

    public String convert(String value) {
        return ParserUtils.convertAndTrim(value);
    }

    public boolean containsKey(Object key) {
        return this.parameters.containsKey(this.convert(String.valueOf(key)));
    }

    public boolean containsDateSelectorKeys(String key) {
        return this.containsKey(key + "_day") && this.containsKey(key + "_month") && this.containsKey(key + "_year");
    }

    public boolean containsTimeSelectorKeys(String key) {
        return this.containsKey(key + "_hour") && this.containsKey(key + "_minute") && this.containsKey(key + "_second");
    }

    public Enumeration keys() {
        return Collections.enumeration(this.keySet());
    }

    public Set keySet() {
        return this.parameters.keySet();
    }

    public Object[] getKeys() {
        return this.keySet().toArray();
    }

    private Boolean parseBoolean(String string) {
        Boolean result = null;
        String value = StringUtils.trim((String)string);
        if (StringUtils.isNotEmpty((String)value)) {
            for (int cnt = 0; cnt < Math.max(trueValues.length, falseValues.length); ++cnt) {
                if (cnt < trueValues.length && value.equalsIgnoreCase(trueValues[cnt])) {
                    result = Boolean.TRUE;
                    break;
                }
                if (cnt >= falseValues.length || !value.equalsIgnoreCase(falseValues[cnt])) continue;
                result = Boolean.FALSE;
                break;
            }
            if (result == null && log.isWarnEnabled()) {
                log.warn((Object)("Parameter with value of (" + value + ") could not be converted to a Boolean"));
            }
        }
        return result;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        Boolean result = this.getBooleanObject(name);
        return result == null ? defaultValue : result;
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean[] getBooleans(String name) {
        boolean[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new boolean[value.length];
            for (int i = 0; i < value.length; ++i) {
                Boolean bool = this.parseBoolean(value[i]);
                result[i] = bool == null ? false : bool;
            }
        }
        return result;
    }

    public Boolean getBooleanObject(String name) {
        return this.parseBoolean(this.getString(name));
    }

    public Boolean getBooleanObject(String name, Boolean defaultValue) {
        Boolean result = this.getBooleanObject(name);
        return result == null ? defaultValue : result;
    }

    public Boolean getBool(String name, boolean defaultValue) {
        return this.getBooleanObject(name, new Boolean(defaultValue));
    }

    public Boolean getBool(String name) {
        return this.getBooleanObject(name, Boolean.FALSE);
    }

    public Boolean[] getBooleanObjects(String name) {
        Boolean[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new Boolean[value.length];
            for (int i = 0; i < value.length; ++i) {
                result[i] = this.parseBoolean(value[i]);
            }
        }
        return result;
    }

    private Number parseNumber(String string) {
        Number result = null;
        String value = StringUtils.trim((String)string);
        if (StringUtils.isNotEmpty((String)value)) {
            ParsePosition pos = new ParsePosition(0);
            Number number = this.numberFormat.parse(value, pos);
            if (pos.getIndex() == value.length()) {
                result = number;
            } else if (log.isWarnEnabled()) {
                log.warn((Object)("Parameter with value of (" + value + ") could not be converted to a Number at position " + pos.getIndex()));
            }
        }
        return result;
    }

    private Number getNumber(String name) {
        return this.parseNumber(this.getString(name));
    }

    public double getDouble(String name, double defaultValue) {
        Number number = this.getNumber(name);
        return number == null ? defaultValue : number.doubleValue();
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public double[] getDoubles(String name) {
        double[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new double[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null ? 0.0 : number.doubleValue();
            }
        }
        return result;
    }

    public Double getDoubleObject(String name, Double defaultValue) {
        Number result = this.getNumber(name);
        return result == null ? defaultValue : new Double(result.doubleValue());
    }

    public Double getDoubleObject(String name) {
        return this.getDoubleObject(name, null);
    }

    public Double[] getDoubleObjects(String name) {
        Double[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new Double[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null ? null : new Double(number.doubleValue());
            }
        }
        return result;
    }

    public float getFloat(String name, float defaultValue) {
        Number number = this.getNumber(name);
        return number == null ? defaultValue : number.floatValue();
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public float[] getFloats(String name) {
        float[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new float[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null ? 0.0f : number.floatValue();
            }
        }
        return result;
    }

    public Float getFloatObject(String name, Float defaultValue) {
        Number result = this.getNumber(name);
        return result == null ? defaultValue : new Float(result.floatValue());
    }

    public Float getFloatObject(String name) {
        return this.getFloatObject(name, null);
    }

    public Float[] getFloatObjects(String name) {
        Float[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new Float[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null ? null : new Float(number.floatValue());
            }
        }
        return result;
    }

    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue) {
        Number result = this.getNumber(name);
        return result == null ? defaultValue : new BigDecimal(result.doubleValue());
    }

    public BigDecimal getBigDecimal(String name) {
        return this.getBigDecimal(name, null);
    }

    public BigDecimal[] getBigDecimals(String name) {
        BigDecimal[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new BigDecimal[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null ? null : new BigDecimal(number.doubleValue());
            }
        }
        return result;
    }

    public int getInt(String name, int defaultValue) {
        Number result = this.getNumber(name);
        return result == null || result instanceof Double ? defaultValue : result.intValue();
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public Integer getInteger(String name, int defaultValue) {
        return this.getIntObject(name, new Integer(defaultValue));
    }

    public Integer getInteger(String name, Integer def) {
        return this.getIntObject(name, def);
    }

    public Integer getInteger(String name) {
        return this.getIntObject(name, new Integer(0));
    }

    public int[] getInts(String name) {
        int[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new int[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null || number instanceof Double ? 0 : number.intValue();
            }
        }
        return result;
    }

    public Integer getIntObject(String name, Integer defaultValue) {
        Number result = this.getNumber(name);
        return result == null || result instanceof Double ? defaultValue : new Integer(result.intValue());
    }

    public Integer getIntObject(String name) {
        return this.getIntObject(name, null);
    }

    public Integer[] getIntObjects(String name) {
        Integer[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new Integer[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null || number instanceof Double ? null : new Integer(number.intValue());
            }
        }
        return result;
    }

    public Integer[] getIntegers(String name) {
        return this.getIntObjects(name);
    }

    public long getLong(String name, long defaultValue) {
        Number result = this.getNumber(name);
        return result == null || result instanceof Double ? defaultValue : result.longValue();
    }

    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    public long[] getLongs(String name) {
        long[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new long[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null || number instanceof Double ? 0L : number.longValue();
            }
        }
        return result;
    }

    public Long[] getLongObjects(String name) {
        Long[] result = null;
        String[] value = this.getParam(name);
        if (value != null) {
            result = new Long[value.length];
            for (int i = 0; i < value.length; ++i) {
                Number number = this.parseNumber(value[i]);
                result[i] = number == null || number instanceof Double ? null : new Long(number.longValue());
            }
        }
        return result;
    }

    public Long getLongObject(String name) {
        return this.getLongObject(name, null);
    }

    public Long getLongObject(String name, Long defaultValue) {
        Number result = this.getNumber(name);
        return result == null || result instanceof Double ? defaultValue : new Long(result.longValue());
    }

    public byte getByte(String name, byte defaultValue) {
        Number result = this.getNumber(name);
        return result == null || result instanceof Double ? defaultValue : result.byteValue();
    }

    public byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    public byte[] getBytes(String name) throws UnsupportedEncodingException {
        byte[] result = null;
        String value = this.getString(name);
        if (value != null) {
            result = value.getBytes(this.getCharacterEncoding());
        }
        return result;
    }

    public Byte getByteObject(String name, Byte defaultValue) {
        Number result = this.getNumber(name);
        return result == null || result instanceof Double ? defaultValue : new Byte(result.byteValue());
    }

    public Byte getByteObject(String name) {
        return this.getByteObject(name, null);
    }

    public String getString(String name) {
        String[] value = this.getParam(name);
        return value == null || value.length == 0 ? null : value[0];
    }

    public String get(String name) {
        return this.getString(name);
    }

    public String getString(String name, String defaultValue) {
        String value = this.getString(name);
        return StringUtils.isEmpty((String)value) ? defaultValue : value;
    }

    public void setString(String name, String value) {
        if (value != null) {
            this.putParam(name, new String[]{value});
        }
    }

    public String[] getStrings(String name) {
        return this.getParam(name);
    }

    public String[] getStrings(String name, String[] defaultValue) {
        String[] value = this.getParam(name);
        return value == null || value.length == 0 ? defaultValue : value;
    }

    public void setStrings(String name, String[] values) {
        if (values != null) {
            this.putParam(name, values);
        }
    }

    public Object getObject(String name) {
        return this.getString(name);
    }

    public Object[] getObjects(String name) {
        return this.getParam(name);
    }

    public Date getDate(String name, DateFormat df, Date defaultValue) {
        Date result = defaultValue;
        String value = StringUtils.trim((String)this.getString(name));
        if (StringUtils.isNotEmpty((String)value)) {
            try {
                df.setLenient(false);
                result = df.parse(value);
            }
            catch (ParseException e) {
                this.logConvertionFailure(name, value, "Date");
            }
        }
        return result;
    }

    public Date getDate(String name) {
        Date date = null;
        if (this.containsDateSelectorKeys(name)) {
            try {
                GregorianCalendar cal = new GregorianCalendar(this.getInt(name + "_year"), this.getInt(name + "_month"), this.getInt(name + "_day"));
                cal.setLenient(false);
                date = cal.getTime();
            }
            catch (IllegalArgumentException e) {
                this.logConvertionFailure(name, "n/a", "Date");
            }
        } else if (this.containsTimeSelectorKeys(name)) {
            try {
                String ampm = this.getString(name + "_ampm");
                int hour = this.getInt(name + "_hour");
                if (ampm != null) {
                    if (hour == 12) {
                        hour = Integer.parseInt(ampm) == 1 ? 12 : 0;
                    } else if (Integer.parseInt(ampm) == 1) {
                        hour += 12;
                    }
                }
                GregorianCalendar cal = new GregorianCalendar(1, 1, 1, hour, this.getInt(name + "_minute"), this.getInt(name + "_second"));
                cal.setLenient(false);
                date = cal.getTime();
            }
            catch (IllegalArgumentException e) {
                this.logConvertionFailure(name, "n/a", "Date");
            }
        } else {
            date = this.getDate(name, this.dateFormat, null);
        }
        return date;
    }

    public Date getDate(String name, DateFormat df) {
        return this.getDate(name, df, null);
    }

    public NumberKey getNumberKey(String name) {
        NumberKey result = null;
        try {
            String value = StringUtils.trim((String)this.getString(name));
            if (StringUtils.isNotEmpty((String)value)) {
                result = new NumberKey(value);
            }
        }
        catch (ClassCastException e) {
            log.error((Object)("Parameter (" + name + ") could not be converted to a NumberKey"), (Throwable)e);
        }
        return result;
    }

    public StringKey getStringKey(String name) {
        StringKey result = null;
        try {
            String value = StringUtils.trim((String)this.getString(name));
            if (StringUtils.isNotEmpty((String)value)) {
                result = new StringKey(value);
            }
        }
        catch (ClassCastException e) {
            log.error((Object)("Parameter (" + name + ") could not be converted to a StringKey"), (Throwable)e);
        }
        return result;
    }

    public void setProperties(Object bean) throws Exception {
        Class<?> beanClass = bean.getClass();
        PropertyDescriptor[] props = Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
        for (int i = 0; i < props.length; ++i) {
            String propname = props[i].getName();
            Method setter = props[i].getWriteMethod();
            if (setter == null || !this.containsKey(propname) && !this.containsDateSelectorKeys(propname) && !this.containsTimeSelectorKeys(propname)) continue;
            this.setProperty(bean, props[i]);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            sb.append('{');
            sb.append(name);
            sb.append('=');
            Object[] params = this.getToStringParam(name);
            if (params == null) {
                sb.append("unknown?");
            } else if (params.length == 0) {
                sb.append("empty");
            } else {
                sb.append('[');
                ArrayIterator it = new ArrayIterator((Object)params);
                while (it.hasNext()) {
                    sb.append(it.next());
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(']');
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    protected Object[] getToStringParam(String name) {
        return this.getParam(name);
    }

    protected void setProperty(Object bean, PropertyDescriptor prop) throws Exception {
        if (prop instanceof IndexedPropertyDescriptor) {
            throw new Exception(prop.getName() + " is an indexed property (not supported)");
        }
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            throw new Exception(prop.getName() + " is a read only property");
        }
        Class<?> propclass = prop.getPropertyType();
        Object[] args = new Object[]{null};
        if (propclass == String.class) {
            args[0] = this.getString(prop.getName());
        } else if (propclass == Byte.class || propclass == Byte.TYPE) {
            args[0] = this.getByteObject(prop.getName());
        } else if (propclass == Integer.class || propclass == Integer.TYPE) {
            args[0] = this.getIntObject(prop.getName());
        } else if (propclass == Long.class || propclass == Long.TYPE) {
            args[0] = this.getLongObject(prop.getName());
        } else if (propclass == Boolean.class || propclass == Boolean.TYPE) {
            args[0] = this.getBooleanObject(prop.getName());
        } else if (propclass == Double.class || propclass == Double.TYPE) {
            args[0] = this.getDoubleObject(prop.getName());
        } else if (propclass == Float.class || propclass == Float.TYPE) {
            args[0] = this.getFloatObject(prop.getName());
        } else if (propclass == BigDecimal.class) {
            args[0] = this.getBigDecimal(prop.getName());
        } else if (propclass == String;.class) {
            args[0] = this.getStrings(prop.getName());
        } else if (propclass == Object.class) {
            args[0] = this.getObject(prop.getName());
        } else if (propclass == [I.class) {
            args[0] = this.getInts(prop.getName());
        } else if (propclass == Integer;.class) {
            args[0] = this.getIntObjects(prop.getName());
        } else if (propclass == Date.class) {
            args[0] = this.getDate(prop.getName());
        } else if (propclass == NumberKey.class) {
            args[0] = this.getNumberKey(prop.getName());
        } else if (propclass == StringKey.class) {
            args[0] = this.getStringKey(prop.getName());
        } else {
            throw new Exception("property " + prop.getName() + " is of unsupported type " + propclass.toString());
        }
        setter.invoke(bean, args);
    }

    private void logConvertionFailure(String paramName, String value, String type) {
        if (log.isWarnEnabled()) {
            log.warn((Object)("Parameter (" + paramName + ") with value of (" + value + ") could not be converted to a " + type));
        }
    }

    protected void putParam(String name, String[] value) {
        String key = this.convert(name);
        if (key != null) {
            this.parameters.put(key, value);
        }
    }

    protected String[] getParam(String name) {
        String key = this.convert(name);
        return key != null ? (String[])this.parameters.get(key) : null;
    }
}

