/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.screens;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ecs.ConcreteElement;
import org.apache.turbine.modules.Screen;
import org.apache.turbine.modules.ScreenLoader;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.assemblerbroker.TurbineAssemblerBroker;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;

public abstract class TemplateScreen
extends Screen {
    protected Log log = LogFactory.getLog(this.getClass());
    private ScreenLoader screenLoader = (ScreenLoader)TurbineAssemblerBroker.getLoader("screen");

    protected abstract void doBuildTemplate(RunData var1) throws Exception;

    protected void doBuildTemplate(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        this.doBuildTemplate(data);
    }

    public abstract ConcreteElement buildTemplate(RunData var1) throws Exception;

    public ConcreteElement buildTemplate(PipelineData pipelineData) throws Exception {
        RunData data = this.getRunData(pipelineData);
        return this.buildTemplate(data);
    }

    protected void doPostBuildTemplate(RunData data) {
    }

    protected void doPostBuildTemplate(PipelineData pipelineData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConcreteElement doBuild(RunData data) throws Exception {
        ConcreteElement out = null;
        try {
            this.doBuildTemplate(data);
            out = this.buildTemplate(data);
        }
        finally {
            this.doPostBuildTemplate(data);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConcreteElement doBuild(PipelineData pipelineData) throws Exception {
        ConcreteElement out = null;
        try {
            this.doBuildTemplate(pipelineData);
            out = this.buildTemplate(pipelineData);
        }
        finally {
            this.doPostBuildTemplate(pipelineData);
        }
        return out;
    }

    public static void setTemplate(RunData data, String template) {
        data.getTemplateInfo().setScreenTemplate(template);
        try {
            data.getTemplateInfo().setLayoutTemplate(TurbineTemplate.getLayoutTemplateName(data.getTemplateInfo().getScreenTemplate()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setTemplate(PipelineData pipelineData, String template) {
        RunData data = (RunData)pipelineData;
        TemplateScreen.setTemplate(data, template);
    }

    public void doRedirect(RunData data, String screen, String template) throws Exception {
        this.log.debug((Object)("doRedirect(data, " + screen + ", " + template + ")"));
        TemplateScreen.setTemplate(data, template);
        this.screenLoader.exec(data, screen);
    }

    public void doRedirect(PipelineData pipelineData, String screen, String template) throws Exception {
        RunData data = this.getRunData(pipelineData);
        this.log.debug((Object)("doRedirect(data, " + screen + ", " + template + ")"));
        TemplateScreen.setTemplate(data, template);
        this.screenLoader.exec(pipelineData, screen);
    }

    public void doRedirect(RunData data, String template) throws Exception {
        this.doRedirect(data, TurbineTemplate.getScreenName(template), template);
    }

    public void doRedirect(PipelineData pipelineData, String template) throws Exception {
        this.doRedirect(pipelineData, template);
    }
}

