/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.pipeline;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.pipeline.AbstractValve;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.pipeline.ValveContext;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;

public class DetermineRedirectRequestedValve
extends AbstractValve {
    private static final Log log = LogFactory.getLog(DetermineRedirectRequestedValve.class);

    @Override
    public void invoke(PipelineData pipelineData, ValveContext context) throws IOException, TurbineException {
        try {
            this.redirectRequested(pipelineData);
        }
        catch (Exception e) {
            throw new TurbineException(e);
        }
        context.invokeNext(pipelineData);
    }

    protected void redirectRequested(PipelineData pipelineData) throws Exception {
        boolean requestRedirected;
        RunData data = this.getRunData(pipelineData);
        boolean bl = requestRedirected = data.getRedirectURI() != null && data.getRedirectURI().length() > 0;
        if (requestRedirected) {
            if (data.getResponse().isCommitted()) {
                requestRedirected = false;
                log.warn((Object)("redirect requested, response already committed: " + data.getRedirectURI()));
            } else {
                data.getResponse().sendRedirect(data.getRedirectURI());
            }
        }
        if (!requestRedirected) {
            try {
                if (!data.isPageSet() && !data.isOutSet()) {
                    throw new Exception("Nothing to output");
                }
                if (data.isPageSet() && !data.isOutSet()) {
                    data.getResponse().setLocale(data.getLocale());
                    data.getResponse().setContentType(data.getContentType());
                    data.getResponse().setStatus(data.getStatusCode());
                    data.getPage().output(data.getResponse().getWriter());
                }
            }
            catch (Exception e) {
                log.debug((Object)"Output stream closed? ", (Throwable)e);
            }
        }
    }
}

