/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.xslt;

import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.fulcrum.xslt.XSLTService;
import org.apache.fulcrum.xslt.XSLTServiceFacade;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultXSLTService
extends AbstractLogEnabled
implements XSLTService,
Initializable,
Configurable,
Contextualizable,
Serviceable {
    private String applicationRoot;
    protected boolean caching = false;
    protected String path;
    protected Hashtable cache = new Hashtable();
    protected static final String STYLESHEET_PATH = "path";
    protected static final String STYLESHEET_CACHING = "cache";
    private static TransformerFactory tfactory;

    private URL getStyleURL(String style) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.path);
        int colon = style.lastIndexOf(".");
        if (colon > 0) {
            sb.append(style.substring(0, colon));
        } else {
            sb.append(style);
        }
        sb.append(".xslt");
        URL url = null;
        try {
            url = new URL(sb.toString());
        }
        catch (MalformedURLException e) {
            this.getLogger().error("Malformed URL: " + sb, (Throwable)e);
        }
        return url;
    }

    protected Templates compileTemplates(URL source) throws Exception {
        StreamSource xslin = new StreamSource(source.openStream());
        return tfactory.newTemplates(xslin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Templates getTemplates(String xslName) throws Exception {
        Hashtable hashtable = this.cache;
        synchronized (hashtable) {
            URL fn = this.getStyleURL(xslName);
            if (fn == null) {
                return null;
            }
            if (this.caching && this.cache.containsKey(fn)) {
                return (Templates)this.cache.get(fn);
            }
            Templates sr = this.compileTemplates(fn);
            if (this.caching) {
                this.cache.put(fn, sr);
            }
            return sr;
        }
    }

    protected void transform(String xslName, Source xmlin, Result xmlout, Map params) throws Exception {
        try {
            long startTime = System.currentTimeMillis();
            Transformer transformer = this.getTransformer(xslName);
            if (params != null) {
                Iterator it = params.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    transformer.setParameter(String.valueOf(entry.getKey()), entry.getValue());
                }
            }
            transformer.transform(xmlin, xmlout);
            if (this.getLogger().isDebugEnabled()) {
                long duration = System.currentTimeMillis() - startTime;
                this.getLogger().debug("The transforamtion '" + xslName + "' took " + duration + " ms");
            }
        }
        catch (Exception e) {
            this.getLogger().debug("The transformation '" + xslName + "' failed due to : " + e.getMessage());
            throw e;
        }
    }

    public void transform(String xslName, Reader in, Writer out) throws Exception {
        StreamSource xmlin = new StreamSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout, null);
    }

    public String transform(String xslName, Reader in) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw, null);
        return sw.toString();
    }

    public void transform(String xslName, Node in, Writer out) throws Exception {
        DOMSource xmlin = new DOMSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout, null);
    }

    public String transform(String xslName, Node in) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw);
        return sw.toString();
    }

    public void transform(String xslName, Reader in, Writer out, Map params) throws Exception {
        StreamSource xmlin = new StreamSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout, params);
    }

    public String transform(String xslName, Reader in, Map params) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw, params);
        return sw.toString();
    }

    public void transform(String xslName, Node in, Writer out, Map params) throws Exception {
        DOMSource xmlin = new DOMSource(in);
        StreamResult xmlout = new StreamResult(out);
        this.transform(xslName, xmlin, xmlout, params);
    }

    public String transform(String xslName, Node in, Map params) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, in, (Writer)sw, params);
        return sw.toString();
    }

    public String transform(String xslName, Map params) throws Exception {
        StringWriter sw = new StringWriter();
        this.transform(xslName, sw, params);
        return sw.toString();
    }

    public void transform(String xslName, Writer out, Map params) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        this.transform(xslName, document.getDocumentElement(), out, params);
    }

    public Transformer getTransformer(String xslName) throws Exception {
        Templates sr = this.getTemplates(xslName);
        if (sr == null) {
            return tfactory.newTransformer();
        }
        return sr.newTransformer();
    }

    public void configure(Configuration conf) throws ConfigurationException {
        StringBuffer sb = new StringBuffer(conf.getAttribute(STYLESHEET_PATH, "/"));
        if (!sb.toString().matches("[a-zA-Z]{3,}://.*")) {
            if (sb.charAt(0) != '/') {
                sb.insert(0, '/');
            }
            sb.insert(0, this.applicationRoot);
            sb.insert(0, "file:");
        }
        if (sb.charAt(sb.length() - 1) != '/') {
            sb.append('/');
        }
        this.path = sb.toString();
        this.caching = conf.getAttributeAsBoolean(STYLESHEET_CACHING, false);
    }

    public void initialize() throws Exception {
        tfactory = TransformerFactory.newInstance();
    }

    public void contextualize(Context context) throws ContextException {
        this.applicationRoot = context.get((Object)"urn:avalon:home").toString();
    }

    public void service(ServiceManager manager) {
        XSLTServiceFacade.setService(this);
    }
}

