/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.StackKeyedObjectPool;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.IntakeService;
import org.apache.fulcrum.intake.IntakeServiceFacade;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.transform.XmlToAppData;
import org.apache.fulcrum.intake.xmlmodel.AppData;
import org.apache.fulcrum.intake.xmlmodel.XmlGroup;

public class IntakeServiceImpl
extends AbstractLogEnabled
implements IntakeService,
Configurable,
Initializable,
Contextualizable,
Serviceable {
    private Map groupNames;
    private Map groupNameMap;
    private Map groupKeyMap;
    private Map getterMap;
    private Map setterMap;
    private Map keyedPools;
    private String applicationRoot;
    private List xmlPathes = null;
    private String serialDataPath = null;

    private boolean registerGroup(String groupName, XmlGroup group, AppData appData, boolean checkKey) {
        if (this.groupNames.keySet().contains(groupName)) {
            return false;
        }
        boolean keyExists = this.groupNameMap.keySet().contains(group.getKey());
        if (checkKey && keyExists) {
            return false;
        }
        this.groupNames.put(groupName, appData);
        this.groupKeyMap.put(groupName, group.getKey());
        if (!keyExists) {
            this.groupNameMap.put(group.getKey(), groupName);
        }
        List classNames = group.getMapToObjects();
        Iterator iter2 = classNames.iterator();
        while (iter2.hasNext()) {
            String className = (String)iter2.next();
            if (this.getterMap.containsKey(className)) continue;
            this.getterMap.put(className, new HashMap());
            this.setterMap.put(className, new HashMap());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadSerialized(String serialDataPath, long timeStamp) {
        this.getLogger().debug("Entered loadSerialized(" + serialDataPath + ", " + timeStamp + ")");
        if (serialDataPath == null) {
            return null;
        }
        File serialDataFile = new File(serialDataPath);
        if (!serialDataFile.exists()) {
            this.getLogger().info("No serialized file found, parsing XML");
            return null;
        }
        if (serialDataFile.lastModified() <= timeStamp) {
            this.getLogger().info("serialized file too old, parsing XML");
            return null;
        }
        FileInputStream in = null;
        Map serialData = null;
        try {
            in = new FileInputStream(serialDataFile);
            ObjectInputStream p = new ObjectInputStream(in);
            Object o = p.readObject();
            if (o instanceof Map) {
                serialData = (Map)o;
            } else {
                this.getLogger().info("serialized object is not an intake map, ignoring");
                ((InputStream)in).close();
                in = null;
                serialDataFile.delete();
            }
        }
        catch (Exception e) {
            this.getLogger().error("Serialized File could not be read.", (Throwable)e);
            serialData = null;
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (Exception e) {
                this.getLogger().error("Exception while closing file", (Throwable)e);
            }
        }
        this.getLogger().info("Loaded serialized map object, ignoring XML");
        return serialData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSerialized(String serialDataPath, Map appDataElements) {
        this.getLogger().debug("Entered saveSerialized(" + serialDataPath + ", appDataElements)");
        if (serialDataPath == null) {
            return;
        }
        File serialData = new File(serialDataPath);
        try {
            serialData.createNewFile();
            serialData.delete();
        }
        catch (Exception e) {
            this.getLogger().info("Could not create serialized file " + serialDataPath + ", not serializing the XML data");
            return;
        }
        FileOutputStream out = null;
        InputStream in = null;
        try {
            out = new FileOutputStream(serialDataPath);
            ObjectOutputStream pout = new ObjectOutputStream(out);
            pout.writeObject(appDataElements);
            pout.flush();
            in = new FileInputStream(serialDataPath);
            ObjectInputStream pin = new ObjectInputStream(in);
            pin.readObject();
            this.getLogger().debug("Serializing successful");
        }
        catch (Exception e) {
            this.getLogger().info("Could not write serialized file to " + serialDataPath + ", not serializing the XML data");
        }
        finally {
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                this.getLogger().error("Exception while closing file", (Throwable)e);
            }
        }
    }

    public Group getGroup(String groupName) throws IntakeException {
        Group group = null;
        AppData appData = (AppData)this.groupNames.get(groupName);
        if (groupName == null) {
            throw new IntakeException("Intake IntakeServiceImpl.getGroup(groupName) is null");
        }
        if (appData == null) {
            throw new IntakeException("Intake IntakeServiceImpl.getGroup(groupName): No XML definition for Group " + groupName + " found");
        }
        try {
            group = (Group)((KeyedObjectPool)this.keyedPools.get(appData)).borrowObject((Object)groupName);
        }
        catch (Exception e) {
            throw new IntakeException("Could not get group " + groupName, e);
        }
        return group;
    }

    public void releaseGroup(Group instance) throws IntakeException {
        if (instance != null) {
            String groupName = instance.getIntakeGroupName();
            AppData appData = (AppData)this.groupNames.get(groupName);
            if (appData == null) {
                throw new IntakeException("Intake IntakeServiceImpl.releaseGroup(groupName): No XML definition for Group " + groupName + " found");
            }
            try {
                ((KeyedObjectPool)this.keyedPools.get(appData)).returnObject((Object)groupName, (Object)instance);
            }
            catch (Exception e) {
                new IntakeException("Could not get group " + groupName, e);
            }
        }
    }

    public int getSize(String groupName) throws IntakeException {
        AppData appData = (AppData)this.groupNames.get(groupName);
        if (appData == null) {
            throw new IntakeException("Intake IntakeServiceImpl.Size(groupName): No XML definition for Group " + groupName + " found");
        }
        KeyedObjectPool kop = (KeyedObjectPool)this.keyedPools.get(groupName);
        return kop.getNumActive((Object)groupName) + kop.getNumIdle((Object)groupName);
    }

    public String[] getGroupNames() {
        return this.groupNames.keySet().toArray(new String[0]);
    }

    public String getGroupKey(String groupName) {
        return (String)this.groupKeyMap.get(groupName);
    }

    public String getGroupName(String groupKey) {
        return (String)this.groupNameMap.get(groupKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getFieldSetter(String className, String propName) throws ClassNotFoundException, IntrospectionException {
        Map settersForClassName = (Map)this.setterMap.get(className);
        if (settersForClassName == null) {
            throw new IntrospectionException("No setter Map for " + className + " available!");
        }
        Method setter = (Method)settersForClassName.get(propName);
        if (setter == null) {
            PropertyDescriptor pd = new PropertyDescriptor(propName, Class.forName(className));
            Map map = this.setterMap;
            synchronized (map) {
                setter = pd.getWriteMethod();
                settersForClassName.put(propName, setter);
                if (setter == null) {
                    this.getLogger().error("Intake: setter for '" + propName + "' in class '" + className + "' could not be found.");
                }
            }
            map = this.getterMap;
            synchronized (map) {
                Method getter;
                Map gettersForClassName = (Map)this.getterMap.get(className);
                if (gettersForClassName != null && (getter = pd.getReadMethod()) != null) {
                    gettersForClassName.put(propName, getter);
                }
            }
        }
        return setter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getFieldGetter(String className, String propName) throws ClassNotFoundException, IntrospectionException {
        Map gettersForClassName = (Map)this.getterMap.get(className);
        if (gettersForClassName == null) {
            throw new IntrospectionException("No getter Map for " + className + " available!");
        }
        Method getter = (Method)gettersForClassName.get(propName);
        if (getter == null) {
            PropertyDescriptor pd = null;
            Map map = this.getterMap;
            synchronized (map) {
                pd = new PropertyDescriptor(propName, Class.forName(className));
                getter = pd.getReadMethod();
                gettersForClassName.put(propName, getter);
                if (getter == null) {
                    this.getLogger().error("Intake: getter for '" + propName + "' in class '" + className + "' could not be found.");
                }
            }
            map = this.setterMap;
            synchronized (map) {
                Method setter;
                Map settersForClassName = (Map)this.getterMap.get(className);
                if (settersForClassName != null && (setter = pd.getWriteMethod()) != null) {
                    settersForClassName.put(propName, setter);
                }
            }
        }
        return getter;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        Configuration xmlPaths = conf.getChild("xmlPaths", false);
        this.xmlPathes = new ArrayList();
        if (xmlPaths == null) {
            this.xmlPathes.add("WEB-INF/conf/intake.xml");
        } else {
            Configuration[] nameVal = xmlPaths.getChildren();
            for (int i = 0; i < nameVal.length; ++i) {
                String val = nameVal[i].getValue();
                this.xmlPathes.add(val);
            }
        }
        this.serialDataPath = conf.getChild("serialDataPath", false).getValue("WEB-INF/appData.ser");
        this.serialDataPath = !this.serialDataPath.equalsIgnoreCase("none") ? new File(this.applicationRoot, this.serialDataPath).getAbsolutePath() : null;
        this.getLogger().debug("Path for serializing: " + this.serialDataPath);
    }

    public void initialize() throws Exception {
        Iterator<Object> it;
        HashMap<AppData, String> appDataElements = null;
        this.groupNames = new HashMap();
        this.groupKeyMap = new HashMap();
        this.groupNameMap = new HashMap();
        this.getterMap = new HashMap();
        this.setterMap = new HashMap();
        this.keyedPools = new HashMap();
        HashSet<String> xmlFiles = new HashSet<String>();
        long timeStamp = 0L;
        Iterator it2 = this.xmlPathes.iterator();
        while (it2.hasNext()) {
            String xmlPath = (String)it2.next();
            File xmlFile = new File(this.applicationRoot, xmlPath).getAbsoluteFile();
            this.getLogger().debug("Path for XML File: " + xmlFile);
            if (!xmlFile.canRead()) {
                String READ_ERR = "Could not read input file with path " + xmlPath + ".  Looking for file " + xmlFile;
                this.getLogger().error(READ_ERR);
                throw new Exception(READ_ERR);
            }
            xmlFiles.add(xmlFile.toString());
            this.getLogger().debug("Added " + xmlPath + " as File to parse");
            timeStamp = xmlFile.lastModified() > timeStamp ? xmlFile.lastModified() : timeStamp;
        }
        HashMap<AppData, String> serializedMap = this.loadSerialized(this.serialDataPath, timeStamp);
        if (serializedMap != null) {
            appDataElements = serializedMap;
            this.getLogger().debug("Using the serialized map");
        } else {
            appDataElements = new HashMap<AppData, String>();
            it = xmlFiles.iterator();
            while (it.hasNext()) {
                String xmlPath = (String)it.next();
                AppData appData = null;
                this.getLogger().debug("Now parsing: " + xmlPath);
                XmlToAppData xmlApp = new XmlToAppData();
                xmlApp.enableLogging(this.getLogger());
                appData = xmlApp.parseFile(xmlPath);
                appDataElements.put(appData, xmlPath);
                this.getLogger().debug("Saving appData for " + xmlPath);
            }
            this.saveSerialized(this.serialDataPath, appDataElements);
        }
        it = appDataElements.keySet().iterator();
        while (it.hasNext()) {
            AppData appData = (AppData)it.next();
            int maxPooledGroups = 0;
            List glist = appData.getGroups();
            String groupPrefix = appData.getGroupPrefix();
            for (int i = glist.size() - 1; i >= 0; --i) {
                XmlGroup g = (XmlGroup)glist.get(i);
                String groupName = g.getName();
                boolean registerUnqualified = this.registerGroup(groupName, g, appData, true);
                if (!registerUnqualified) {
                    this.getLogger().info("Ignored redefinition of Group " + groupName + " or Key " + g.getKey() + " from " + appDataElements.get(appData));
                }
                if (groupPrefix != null) {
                    StringBuffer qualifiedName = new StringBuffer();
                    qualifiedName.append(groupPrefix).append(':').append(groupName);
                    if (!this.registerGroup(qualifiedName.toString(), g, appData, !registerUnqualified)) {
                        this.getLogger().error("Could not register fully qualified name " + qualifiedName + ", maybe two XML files have the same prefix. Ignoring it.");
                    }
                }
                maxPooledGroups = Math.max(maxPooledGroups, Integer.parseInt(g.getPoolCapacity()));
            }
            Group.GroupFactory factory = new Group.GroupFactory(appData);
            this.keyedPools.put(appData, new StackKeyedObjectPool((KeyedPoolableObjectFactory)factory, maxPooledGroups));
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Intake Service is initialized now.");
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.applicationRoot = context.get((Object)"urn:avalon:home").toString();
    }

    public void service(ServiceManager manager) throws ServiceException {
        IntakeServiceFacade.setIntakeService(this);
    }
}

