/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.InvalidMaskException;
import org.apache.fulcrum.intake.validator.NumberValidator;
import org.apache.fulcrum.intake.validator.ValidationException;

public class LongValidator
extends NumberValidator {
    private long minValue = Long.MIN_VALUE;
    private long maxValue = Long.MAX_VALUE;

    public LongValidator(Map paramMap) throws InvalidMaskException {
        this();
        this.init(paramMap);
    }

    public LongValidator() {
        this.invalidNumberMessage = "Entry was not a valid Long";
    }

    public void init(Map paramMap) throws InvalidMaskException {
        String param;
        super.init(paramMap);
        Constraint constraint = (Constraint)paramMap.get("minValue");
        if (constraint != null) {
            param = constraint.getValue();
            this.minValue = Long.parseLong(param);
            this.minValueMessage = constraint.getMessage();
        }
        if ((constraint = (Constraint)paramMap.get("maxValue")) != null) {
            param = constraint.getValue();
            this.maxValue = Long.parseLong(param);
            this.maxValueMessage = constraint.getMessage();
        }
    }

    public void assertValidity(String testValue) throws ValidationException {
        super.assertValidity(testValue);
        if (this.required || StringUtils.isNotEmpty((String)testValue)) {
            long l = 0L;
            try {
                l = Long.parseLong(testValue);
            }
            catch (RuntimeException e) {
                this.errorMessage = this.invalidNumberMessage;
                throw new ValidationException(this.invalidNumberMessage);
            }
            if (l < this.minValue) {
                this.errorMessage = this.minValueMessage;
                throw new ValidationException(this.minValueMessage);
            }
            if (l > this.maxValue) {
                this.errorMessage = this.maxValueMessage;
                throw new ValidationException(this.maxValueMessage);
            }
        }
    }

    public long getMinValue() {
        return this.minValue;
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }
}

