/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avalon.excalibur.logger.factory.AbstractTargetFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log.LogTarget;
import org.apache.log.output.net.SocketOutputTarget;

public class SocketTargetFactory
extends AbstractTargetFactory {
    public LogTarget createTarget(Configuration conf) throws ConfigurationException {
        InetAddress address;
        Configuration configChild = conf.getChild("address", false);
        if (null == configChild) {
            throw new ConfigurationException("target address not specified in the config");
        }
        try {
            address = InetAddress.getByName(configChild.getAttribute("hostname"));
        }
        catch (UnknownHostException uhex) {
            throw new ConfigurationException("Host specified in socket target adress is unknown!", (Throwable)uhex);
        }
        int port = configChild.getAttributeAsInteger("port");
        try {
            return new SocketOutputTarget(address, port);
        }
        catch (IOException ioex) {
            throw new ConfigurationException("Failed to create target!", ioex.fillInStackTrace());
        }
    }
}

