/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.BaseObject;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Transaction;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.services.schedule.JobEntryPeer;

public abstract class BaseJobEntry
extends BaseObject {
    private static final long serialVersionUID = 1308842746584L;
    private static final JobEntryPeer peer = new JobEntryPeer();
    private int jobId;
    private int second = -1;
    private int minute = -1;
    private int hour = -1;
    private int weekDay = -1;
    private int dayOfMonth = -1;
    private String task;
    private String email;
    private byte[] property;
    private static List<String> fieldNames = null;
    private boolean alreadyInSave = false;

    public int getJobId() {
        return this.jobId;
    }

    public void setJobId(int v) {
        if (this.jobId != v) {
            this.jobId = v;
            this.setModified(true);
        }
    }

    public int getSecond() {
        return this.second;
    }

    public void setSecond(int v) {
        if (this.second != v) {
            this.second = v;
            this.setModified(true);
        }
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int v) {
        if (this.minute != v) {
            this.minute = v;
            this.setModified(true);
        }
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int v) {
        if (this.hour != v) {
            this.hour = v;
            this.setModified(true);
        }
    }

    public int getWeekDay() {
        return this.weekDay;
    }

    public void setWeekDay(int v) {
        if (this.weekDay != v) {
            this.weekDay = v;
            this.setModified(true);
        }
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(int v) {
        if (this.dayOfMonth != v) {
            this.dayOfMonth = v;
            this.setModified(true);
        }
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String v) {
        if (!ObjectUtils.equals((Object)this.task, (Object)v)) {
            this.task = v;
            this.setModified(true);
        }
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String v) {
        if (!ObjectUtils.equals((Object)this.email, (Object)v)) {
            this.email = v;
            this.setModified(true);
        }
    }

    public byte[] getProperty() {
        return this.property;
    }

    public void setProperty(byte[] v) {
        if (!ObjectUtils.equals((Object)this.property, (Object)v)) {
            this.property = v;
            this.setModified(true);
        }
    }

    public static synchronized List<String> getFieldNames() {
        if (fieldNames == null) {
            fieldNames = new ArrayList<String>();
            fieldNames.add("JobId");
            fieldNames.add("Second");
            fieldNames.add("Minute");
            fieldNames.add("Hour");
            fieldNames.add("WeekDay");
            fieldNames.add("DayOfMonth");
            fieldNames.add("Task");
            fieldNames.add("Email");
            fieldNames.add("Property");
            fieldNames = Collections.unmodifiableList(fieldNames);
        }
        return fieldNames;
    }

    public Object getByName(String name) {
        if (name.equals("JobId")) {
            return new Integer(this.getJobId());
        }
        if (name.equals("Second")) {
            return new Integer(this.getSecond());
        }
        if (name.equals("Minute")) {
            return new Integer(this.getMinute());
        }
        if (name.equals("Hour")) {
            return new Integer(this.getHour());
        }
        if (name.equals("WeekDay")) {
            return new Integer(this.getWeekDay());
        }
        if (name.equals("DayOfMonth")) {
            return new Integer(this.getDayOfMonth());
        }
        if (name.equals("Task")) {
            return this.getTask();
        }
        if (name.equals("Email")) {
            return this.getEmail();
        }
        if (name.equals("Property")) {
            return this.getProperty();
        }
        return null;
    }

    public boolean setByName(String name, Object value) throws TorqueException, IllegalArgumentException {
        if (name.equals("JobId")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setJobId((Integer)value);
            return true;
        }
        if (name.equals("Second")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setSecond((Integer)value);
            return true;
        }
        if (name.equals("Minute")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setMinute((Integer)value);
            return true;
        }
        if (name.equals("Hour")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setHour((Integer)value);
            return true;
        }
        if (name.equals("WeekDay")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setWeekDay((Integer)value);
            return true;
        }
        if (name.equals("DayOfMonth")) {
            if (value == null || !Integer.class.isInstance(value)) {
                throw new IllegalArgumentException("setByName: value parameter was null or not an Integer object.");
            }
            this.setDayOfMonth((Integer)value);
            return true;
        }
        if (name.equals("Task")) {
            if (value != null && !String.class.isInstance(value)) {
                throw new IllegalArgumentException("Invalid type of object specified for value in setByName");
            }
            this.setTask((String)value);
            return true;
        }
        if (name.equals("Email")) {
            if (value != null && !String.class.isInstance(value)) {
                throw new IllegalArgumentException("Invalid type of object specified for value in setByName");
            }
            this.setEmail((String)value);
            return true;
        }
        if (name.equals("Property")) {
            if (value != null && !byte[].class.isInstance(value)) {
                throw new IllegalArgumentException("Invalid type of object specified for value in setByName");
            }
            this.setProperty((byte[])value);
            return true;
        }
        return false;
    }

    public Object getByPeerName(String name) {
        if (name.equals(JobEntryPeer.JOB_ID)) {
            return new Integer(this.getJobId());
        }
        if (name.equals(JobEntryPeer.SECOND)) {
            return new Integer(this.getSecond());
        }
        if (name.equals(JobEntryPeer.MINUTE)) {
            return new Integer(this.getMinute());
        }
        if (name.equals(JobEntryPeer.HOUR)) {
            return new Integer(this.getHour());
        }
        if (name.equals(JobEntryPeer.WEEK_DAY)) {
            return new Integer(this.getWeekDay());
        }
        if (name.equals(JobEntryPeer.DAY_OF_MONTH)) {
            return new Integer(this.getDayOfMonth());
        }
        if (name.equals(JobEntryPeer.TASK)) {
            return this.getTask();
        }
        if (name.equals(JobEntryPeer.EMAIL)) {
            return this.getEmail();
        }
        if (name.equals(JobEntryPeer.PROPERTY)) {
            return this.getProperty();
        }
        return null;
    }

    public boolean setByPeerName(String name, Object value) throws TorqueException, IllegalArgumentException {
        if (JobEntryPeer.JOB_ID.equals(name)) {
            return this.setByName("JobId", value);
        }
        if (JobEntryPeer.SECOND.equals(name)) {
            return this.setByName("Second", value);
        }
        if (JobEntryPeer.MINUTE.equals(name)) {
            return this.setByName("Minute", value);
        }
        if (JobEntryPeer.HOUR.equals(name)) {
            return this.setByName("Hour", value);
        }
        if (JobEntryPeer.WEEK_DAY.equals(name)) {
            return this.setByName("WeekDay", value);
        }
        if (JobEntryPeer.DAY_OF_MONTH.equals(name)) {
            return this.setByName("DayOfMonth", value);
        }
        if (JobEntryPeer.TASK.equals(name)) {
            return this.setByName("Task", value);
        }
        if (JobEntryPeer.EMAIL.equals(name)) {
            return this.setByName("Email", value);
        }
        if (JobEntryPeer.PROPERTY.equals(name)) {
            return this.setByName("Property", value);
        }
        return false;
    }

    public Object getByPosition(int pos) {
        if (pos == 0) {
            return new Integer(this.getJobId());
        }
        if (pos == 1) {
            return new Integer(this.getSecond());
        }
        if (pos == 2) {
            return new Integer(this.getMinute());
        }
        if (pos == 3) {
            return new Integer(this.getHour());
        }
        if (pos == 4) {
            return new Integer(this.getWeekDay());
        }
        if (pos == 5) {
            return new Integer(this.getDayOfMonth());
        }
        if (pos == 6) {
            return this.getTask();
        }
        if (pos == 7) {
            return this.getEmail();
        }
        if (pos == 8) {
            return this.getProperty();
        }
        return null;
    }

    public boolean setByPosition(int position, Object value) throws TorqueException, IllegalArgumentException {
        if (position == 0) {
            return this.setByName("JobId", value);
        }
        if (position == 1) {
            return this.setByName("Second", value);
        }
        if (position == 2) {
            return this.setByName("Minute", value);
        }
        if (position == 3) {
            return this.setByName("Hour", value);
        }
        if (position == 4) {
            return this.setByName("WeekDay", value);
        }
        if (position == 5) {
            return this.setByName("DayOfMonth", value);
        }
        if (position == 6) {
            return this.setByName("Task", value);
        }
        if (position == 7) {
            return this.setByName("Email", value);
        }
        if (position == 8) {
            return this.setByName("Property", value);
        }
        return false;
    }

    public void save() throws Exception {
        this.save(JobEntryPeer.DATABASE_NAME);
    }

    public void save(String dbName) throws TorqueException {
        Connection con = null;
        try {
            con = Transaction.begin((String)dbName);
            this.save(con);
            Transaction.commit((Connection)con);
        }
        catch (TorqueException e) {
            Transaction.safeRollback((Connection)con);
            throw e;
        }
    }

    public void save(Connection con) throws TorqueException {
        if (!this.alreadyInSave) {
            this.alreadyInSave = true;
            if (this.isModified()) {
                if (this.isNew()) {
                    JobEntryPeer.doInsert((JobEntry)this, con);
                    this.setNew(false);
                } else {
                    JobEntryPeer.doUpdate((JobEntry)this, con);
                }
            }
            this.alreadyInSave = false;
        }
    }

    public void setPrimaryKey(ObjectKey key) {
        this.setJobId(((NumberKey)key).intValue());
    }

    public void setPrimaryKey(String key) {
        this.setJobId(Integer.parseInt(key));
    }

    public ObjectKey getPrimaryKey() {
        return SimpleKey.keyFor((int)this.getJobId());
    }

    public JobEntry copy() throws TorqueException {
        return this.copy(true);
    }

    public JobEntry copy(Connection con) throws TorqueException {
        return this.copy(true, con);
    }

    public JobEntry copy(boolean deepcopy) throws TorqueException {
        return this.copyInto(new JobEntry(), deepcopy);
    }

    public JobEntry copy(boolean deepcopy, Connection con) throws TorqueException {
        return this.copyInto(new JobEntry(), deepcopy, con);
    }

    protected JobEntry copyInto(JobEntry copyObj) throws TorqueException {
        return this.copyInto(copyObj, true);
    }

    protected JobEntry copyInto(JobEntry copyObj, Connection con) throws TorqueException {
        return this.copyInto(copyObj, true, con);
    }

    protected JobEntry copyInto(JobEntry copyObj, boolean deepcopy) throws TorqueException {
        copyObj.setJobId(this.jobId);
        copyObj.setSecond(this.second);
        copyObj.setMinute(this.minute);
        copyObj.setHour(this.hour);
        copyObj.setWeekDay(this.weekDay);
        copyObj.setDayOfMonth(this.dayOfMonth);
        copyObj.setTask(this.task);
        copyObj.setEmail(this.email);
        copyObj.setProperty(this.property);
        copyObj.setJobId(0);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    protected JobEntry copyInto(JobEntry copyObj, boolean deepcopy, Connection con) throws TorqueException {
        copyObj.setJobId(this.jobId);
        copyObj.setSecond(this.second);
        copyObj.setMinute(this.minute);
        copyObj.setHour(this.hour);
        copyObj.setWeekDay(this.weekDay);
        copyObj.setDayOfMonth(this.dayOfMonth);
        copyObj.setTask(this.task);
        copyObj.setEmail(this.email);
        copyObj.setProperty(this.property);
        copyObj.setJobId(0);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    public JobEntryPeer getPeer() {
        return peer;
    }

    public TableMap getTableMap() throws TorqueException {
        return JobEntryPeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("JobEntry:\n");
        str.append("JobId = ").append(this.getJobId()).append("\n");
        str.append("Second = ").append(this.getSecond()).append("\n");
        str.append("Minute = ").append(this.getMinute()).append("\n");
        str.append("Hour = ").append(this.getHour()).append("\n");
        str.append("WeekDay = ").append(this.getWeekDay()).append("\n");
        str.append("DayOfMonth = ").append(this.getDayOfMonth()).append("\n");
        str.append("Task = ").append(this.getTask()).append("\n");
        str.append("Email = ").append(this.getEmail()).append("\n");
        str.append("Property = ").append("<binary>").append("\n");
        return str.toString();
    }
}

