/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.security;

import java.util.Map;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.security.AccessControlList;
import org.apache.turbine.util.security.GroupSet;
import org.apache.turbine.util.security.PermissionSet;
import org.apache.turbine.util.security.RoleSet;
import org.apache.turbine.util.security.TurbineSecurityException;

public class TurbineAccessControlList
implements AccessControlList {
    private Map roleSets;
    private Map permissionSets;
    private String name;

    public TurbineAccessControlList(Map roleSets, Map permissionSets) {
        this.roleSets = roleSets;
        this.permissionSets = permissionSets;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public RoleSet getRoles(Group group) {
        if (group == null) {
            return null;
        }
        return (RoleSet)this.roleSets.get(group);
    }

    @Override
    public RoleSet getRoles() {
        return this.getRoles(TurbineSecurity.getGlobalGroup());
    }

    @Override
    public PermissionSet getPermissions(Group group) {
        if (group == null) {
            return null;
        }
        return (PermissionSet)this.permissionSets.get(group);
    }

    @Override
    public PermissionSet getPermissions() {
        return this.getPermissions(TurbineSecurity.getGlobalGroup());
    }

    @Override
    public boolean hasRole(Role role, Group group) {
        RoleSet set = this.getRoles(group);
        if (set == null || role == null) {
            return false;
        }
        return set.contains(role);
    }

    @Override
    public boolean hasRole(Role role, GroupSet groupset) {
        if (role == null) {
            return false;
        }
        for (Group group : groupset) {
            RoleSet roles = this.getRoles(group);
            if (roles == null || !roles.contains(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRole(String role, String group) {
        try {
            return this.hasRole(TurbineSecurity.getRoleByName(role), TurbineSecurity.getGroupByName(group));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasRole(String rolename, GroupSet groupset) {
        Role role;
        try {
            role = TurbineSecurity.getRoleByName(rolename);
        }
        catch (TurbineSecurityException e) {
            return false;
        }
        if (role == null) {
            return false;
        }
        for (Group group : groupset) {
            RoleSet roles = this.getRoles(group);
            if (roles == null || !roles.contains(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRole(Role role) {
        return this.hasRole(role, TurbineSecurity.getGlobalGroup());
    }

    @Override
    public boolean hasRole(String role) {
        try {
            return this.hasRole(TurbineSecurity.getRoleByName(role));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasPermission(Permission permission, Group group) {
        PermissionSet set = this.getPermissions(group);
        if (set == null || permission == null) {
            return false;
        }
        return set.contains(permission);
    }

    @Override
    public boolean hasPermission(Permission permission, GroupSet groupset) {
        if (permission == null) {
            return false;
        }
        for (Group group : groupset) {
            PermissionSet permissions = this.getPermissions(group);
            if (permissions == null || !permissions.contains(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPermission(String permission, String group) {
        try {
            return this.hasPermission(TurbineSecurity.getPermissionByName(permission), TurbineSecurity.getGroupByName(group));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasPermission(String permission, Group group) {
        try {
            return this.hasPermission(TurbineSecurity.getPermissionByName(permission), group);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean hasPermission(String permissionName, GroupSet groupset) {
        Permission permission;
        try {
            permission = TurbineSecurity.getPermissionByName(permissionName);
        }
        catch (TurbineSecurityException e) {
            return false;
        }
        if (permission == null) {
            return false;
        }
        for (Group group : groupset) {
            PermissionSet permissions = this.getPermissions(group);
            if (permissions == null || !permissions.contains(permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPermission(Permission permission) {
        return this.hasPermission(permission, TurbineSecurity.getGlobalGroup());
    }

    @Override
    public boolean hasPermission(String permission) {
        try {
            return this.hasPermission(TurbineSecurity.getPermissionByName(permission));
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Group[] getAllGroups() {
        try {
            return TurbineSecurity.getAllGroups().getGroupsArray();
        }
        catch (TurbineSecurityException e) {
            return new Group[0];
        }
    }
}

