/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.taeconfigurator.editors.ui.dialogs;

import org.apache.uima.taeconfigurator.editors.ui.AbstractSection;
import org.apache.uima.taeconfigurator.editors.ui.Utility;
import org.apache.uima.taeconfigurator.editors.ui.dialogs.AbstractDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractDialogMultiColTable
extends AbstractDialog {
    protected static final String UNCHECKED = "";
    Tree f_tree;
    protected boolean enableCol1 = true;
    protected boolean enableCol2 = true;
    protected int numberChecked = 0;

    protected String checkedIndicator(int col) {
        if (col == 1) {
            return "In";
        }
        return "Out";
    }

    protected AbstractDialogMultiColTable(AbstractSection aSection, String title, String description) {
        super(aSection, title, description);
    }

    @Override
    public void handleEvent(Event event) {
        if (event.type == 3 && event.widget == this.f_tree) {
            Point mousePosition = new Point(event.x, event.y);
            TreeItem item = this.f_tree.getItem(mousePosition);
            if (null == item) {
                this.jitHowTo(event.widget);
                return;
            }
            int col = this.getHitColumn(item, mousePosition);
            if (col != 1 && col != 2) {
                this.jitHowTo(event.widget);
                return;
            }
            if (col == 1 && !this.enableCol1) {
                this.setErrorMessage("This resource can't be marked as input");
                return;
            }
            if (col == 2 && !this.enableCol2) {
                this.setErrorMessage("This resource can't be marked as output");
                return;
            }
            this.errorMessageUI.setText(UNCHECKED);
            this.toggleValue(item, col);
        }
        super.handleEvent(event);
    }

    private void jitHowTo(Widget w) {
        Utility.popMessage(w, "Where to mouse click", "Please click the mouse in the input or output columns to toggle the selection.", 2);
    }

    protected void toggleValue(TableItem item, int col) {
        item.setText(col, item.getText(col).equals(this.checkedIndicator(col)) ? UNCHECKED : this.checkedIndicator(col));
        this.numberChecked = item.getText(col).equals(this.checkedIndicator(col)) ? ++this.numberChecked : --this.numberChecked;
    }

    protected void toggleValue(TreeItem item, int col) {
        item.setText(col, item.getText(col).equals(this.checkedIndicator(col)) ? UNCHECKED : this.checkedIndicator(col));
        this.numberChecked = item.getText(col).equals(this.checkedIndicator(col)) ? ++this.numberChecked : --this.numberChecked;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void enableOK() {
        this.errorMessageUI.setText(UNCHECKED);
        this.okButton.setEnabled(this.numberChecked > 0);
    }

    protected void setChecked(TableItem item, int col, boolean value) {
        boolean prevChecked = this.checkedIndicator(col).equals(item.getText(col));
        item.setText(col, value ? this.checkedIndicator(col) : UNCHECKED);
        if (value && !prevChecked) {
            ++this.numberChecked;
        } else if (!value && prevChecked) {
            --this.numberChecked;
        }
    }

    protected void setChecked(TreeItem item, int col, boolean value) {
        boolean prevChecked = this.checkedIndicator(col).equals(item.getText(col));
        item.setText(col, value ? this.checkedIndicator(col) : UNCHECKED);
        if (value && !prevChecked) {
            ++this.numberChecked;
        } else if (!value && prevChecked) {
            --this.numberChecked;
        }
    }
}

