/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.metadata.FsIndexCollection;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.spi.TypeSystemProvider;
import org.apache.uima.util.TypeSystemUtil;

public abstract class TypeSystemProvider_ImplBase
implements TypeSystemProvider {
    private Set<String> typeSystemPaths = Collections.emptySet();
    private Set<String> fsIndexCollectionPaths = Collections.emptySet();
    private Set<String> typePrioritiesPaths = Collections.emptySet();
    private List<TypeSystemDescription> typeSystemDescriptions;
    private List<FsIndexCollection> fsIndexCollections;
    private List<TypePriorities> typePriorities;
    private List<Class<? extends TOP>> jCasClasses;

    protected void setTypeSystemLocations(String ... aLocations) {
        this.typeSystemPaths = Collections.unmodifiableSet(this.resolveLocations(aLocations));
    }

    @Override
    public synchronized List<TypeSystemDescription> listTypeSystemDescriptions() {
        if (this.typeSystemDescriptions == null) {
            this.typeSystemDescriptions = TypeSystemUtil.loadTypeSystemDescriptionsFromClasspath(this.getClass(), (String[])this.typeSystemPaths.toArray(String[]::new));
        }
        return this.typeSystemDescriptions;
    }

    protected void setFsIndexCollectionLocations(String ... aLocations) {
        this.fsIndexCollectionPaths = Collections.unmodifiableSet(this.resolveLocations(aLocations));
    }

    @Override
    public synchronized List<FsIndexCollection> listFsIndexCollections() {
        if (this.fsIndexCollections == null) {
            this.fsIndexCollections = TypeSystemUtil.loadFsIndexCollectionsFromClasspath(this.getClass(), (String[])this.fsIndexCollectionPaths.toArray(String[]::new));
        }
        return this.fsIndexCollections;
    }

    protected void setTypePrioritiesLocations(String ... aLocations) {
        this.typePrioritiesPaths = Collections.unmodifiableSet(this.resolveLocations(aLocations));
    }

    @Override
    public synchronized List<TypePriorities> listTypePriorities() {
        if (this.typePriorities == null) {
            this.typePriorities = TypeSystemUtil.loadTypePrioritiesFromClasspath(this.getClass(), (String[])this.typePrioritiesPaths.toArray(String[]::new));
        }
        return this.typePriorities;
    }

    private Set<String> resolveLocations(String ... aLocations) {
        HashSet<String> paths = new HashSet<String>();
        String packagePath = "/" + this.getClass().getPackage().getName().replace('.', '/') + "/";
        for (String location : aLocations) {
            Object path = location;
            if (!((String)path).startsWith("/")) {
                path = packagePath + (String)path;
            }
            paths.add((String)path);
        }
        return paths;
    }

    @Override
    public Optional<URL> findResourceUrl(String aName) {
        String fullName = "/" + aName.replace('.', '/') + ".xml";
        if (this.typeSystemPaths.contains(fullName)) {
            return Optional.ofNullable(this.getClass().getResource(fullName));
        }
        return Optional.empty();
    }

    @Override
    public synchronized List<Class<? extends TOP>> listJCasClasses() {
        if (this.jCasClasses == null) {
            ArrayList<Class<? extends TOP>> classes = new ArrayList<Class<? extends TOP>>();
            ClassLoader cl = this.getClass().getClassLoader();
            for (TypeSystemDescription tsd : this.listTypeSystemDescriptions()) {
                for (TypeDescription td : tsd.getTypes()) {
                    try {
                        classes.add(cl.loadClass(td.getName()));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
            this.jCasClasses = classes;
        }
        return this.jCasClasses;
    }
}

