/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.parser.stax;

import javax.xml.stream.XMLStreamReader;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Text;
import org.apache.abdera.parser.ParseException;
import org.apache.abdera.parser.ParserOptions;
import org.apache.abdera.parser.stax.FOMFactory;
import org.apache.abdera.parser.stax.FOMStAXFilter;
import org.apache.abdera.parser.stax.FOMUnsupportedContentTypeException;
import org.apache.abdera.parser.stax.FOMUnsupportedTextTypeException;
import org.apache.abdera.util.Constants;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOMBuilder
extends StAXOMBuilder
implements Constants {
    private final FOMFactory fomfactory;
    private final ParserOptions parserOptions;

    public FOMBuilder(FOMFactory factory, XMLStreamReader parser, ParserOptions parserOptions) {
        super((OMFactory)factory, (XMLStreamReader)((Object)new FOMStAXFilter(parser, parserOptions)), null, null);
        this.parserOptions = parserOptions;
        this.fomfactory = factory;
    }

    public ParserOptions getParserOptions() {
        return this.parserOptions;
    }

    protected Text.Type getTextType() {
        Text.Type ttype = Text.Type.TEXT;
        String type = this.parser.getAttributeValue(null, "type");
        if (type != null && (ttype = Text.Type.typeFromString((String)type)) == null) {
            throw new FOMUnsupportedTextTypeException(type);
        }
        return ttype;
    }

    protected Content.Type getContentType() {
        Content.Type ctype = Content.Type.TEXT;
        String type = this.parser.getAttributeValue(null, "type");
        String src = this.parser.getAttributeValue(null, "src");
        if (type != null) {
            ctype = Content.Type.typeFromString((String)type);
            if (ctype == null) {
                throw new FOMUnsupportedContentTypeException(type);
            }
        } else if (type == null && src != null) {
            ctype = Content.Type.MEDIA;
        }
        return ctype;
    }

    public int next() throws OMException {
        try {
            return super.next();
        }
        catch (OMException e) {
            throw new ParseException((Throwable)e);
        }
    }

    protected OMElement constructNode(OMContainer parent, String name) {
        return this.fomfactory.createElementFromBuilder(this.parser.getName(), parent, this);
    }

    public <T extends Element> Document<T> getFomDocument() {
        this.getDocumentElement();
        return (Document)this.getDocument();
    }

    public FOMFactory getFactory() {
        return this.fomfactory;
    }
}

