/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.parser.stax;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.MimeType;
import org.apache.abdera.model.Collection;
import org.apache.abdera.model.Element;
import org.apache.abdera.parser.stax.FOMCollection;
import org.apache.abdera.util.Constants;
import org.apache.abdera.util.MimeTypeHelper;
import org.apache.abdera.util.MimeTypeParseException;
import org.apache.axiom.fom.AbderaCollection;
import org.apache.axiom.fom.AbderaCollectionMixin;
import org.apache.axiom.fom.AbderaElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOMMultipartCollection
extends FOMCollection {
    public boolean acceptsMultipart(String mediaType) {
        Map<String, String> accept = this.getAcceptMultiparted();
        if (accept.size() == 0) {
            accept = Collections.singletonMap("application/atom+xml;type=entry", null);
        }
        for (Map.Entry<String, String> entry : accept.entrySet()) {
            if (!MimeTypeHelper.isMatch((String)entry.getKey(), (String)mediaType) || entry.getValue() == null || !entry.getValue().equals("multipart-related")) continue;
            return true;
        }
        return false;
    }

    public boolean acceptsMultipart(MimeType mediaType) {
        return AbderaCollectionMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_AbderaCollectionMixin$org_apache_axiom_fom_AbderaCollection$accepts((AbderaCollection)this, mediaType.toString());
    }

    public Map<String, String> getAcceptMultiparted() {
        HashMap<String, String> accept = new HashMap<String, String>();
        Iterator<AbderaElement> i = this._getChildrenWithName(Constants.ACCEPT);
        if (i == null || !i.hasNext()) {
            i = this._getChildrenWithName(Constants.PRE_RFC_ACCEPT);
        }
        while (i.hasNext()) {
            Element e = i.next();
            String t = e.getText();
            if (t == null) continue;
            if (e.getAttributeValue(Constants.ALTERNATE) != null && e.getAttributeValue(Constants.ALTERNATE).trim().length() > 0) {
                accept.put(t.trim(), e.getAttributeValue(Constants.ALTERNATE));
                continue;
            }
            accept.put(t.trim(), null);
        }
        return accept;
    }

    public Collection setAccept(String mediaRange, String alternate) {
        return this.setAccept(Collections.singletonMap(mediaRange, alternate));
    }

    public Collection setAccept(Map<String, String> mediaRanges) {
        if (mediaRanges != null && mediaRanges.size() > 0) {
            this._removeChildren(Constants.ACCEPT, true);
            this._removeChildren(Constants.PRE_RFC_ACCEPT, true);
            if (mediaRanges.size() == 1 && mediaRanges.keySet().iterator().next().equals("")) {
                this.addExtension(Constants.ACCEPT);
            } else {
                for (Map.Entry<String, String> entry : mediaRanges.entrySet()) {
                    if (entry.getKey().equalsIgnoreCase("entry")) {
                        this.addSimpleExtension(Constants.ACCEPT, "application/atom+xml;type=entry");
                        continue;
                    }
                    try {
                        Element accept = this.addSimpleExtension(Constants.ACCEPT, new MimeType(entry.getKey()).toString());
                        if (entry.getValue() == null) continue;
                        accept.setAttributeValue(Constants.ALTERNATE, entry.getValue());
                    }
                    catch (javax.activation.MimeTypeParseException e) {
                        throw new MimeTypeParseException(e);
                    }
                }
            }
        } else {
            this._removeChildren(Constants.ACCEPT, true);
            this._removeChildren(Constants.PRE_RFC_ACCEPT, true);
        }
        return this;
    }

    public Collection addAccepts(String mediaRange, String alternate) {
        return this.addAccepts(Collections.singletonMap(mediaRange, alternate));
    }

    public Collection addAccepts(Map<String, String> mediaRanges) {
        if (mediaRanges != null) {
            for (Map.Entry<String, String> entry : mediaRanges.entrySet()) {
                if (AbderaCollectionMixin.ajc$interMethodDispatch1$org_apache_axiom_fom_AbderaCollectionMixin$org_apache_axiom_fom_AbderaCollection$accepts((AbderaCollection)this, entry.getKey())) continue;
                try {
                    Element accept = this.addSimpleExtension(Constants.ACCEPT, new MimeType(entry.getKey()).toString());
                    if (entry.getValue() == null) continue;
                    accept.setAttributeValue(Constants.ALTERNATE, entry.getValue());
                }
                catch (Exception exception) {}
            }
        }
        return this;
    }
}

