
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 * DOMImplementationRegistry.getDOMImplementationList("cOrE 3.0 xMl 3.0 eVeNts 2.0 lS") 
 * should return an empty list or a list of DOMImplementation that implements the specified features.
* @author Curt Arnold
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/java-binding">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/java-binding</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/ecma-script-binding">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/ecma-script-binding</a>
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-getDOMImpls">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-getDOMImpls</a>
*/
public final class domimplementationregistry23 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    */
   public domimplementationregistry23(final DOMTestDocumentBuilderFactory factory)  {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      org.w3c.dom.bootstrap.DOMImplementationRegistry domImplRegistry;
      DOMImplementation domImpl;
      boolean hasCore;
      boolean hasXML;
      boolean hasEvents;
      boolean hasLS;
      DOMImplementation baseImpl;
      String nullVersion = null;

      DOMImplementationList domImplList;
      int length;
      domImplRegistry = org.w3c.dom.bootstrap.DOMImplementationRegistry.newInstance();
         assertNotNull("domImplRegistryNotNull", domImplRegistry);
      domImplList = domImplRegistry.getDOMImplementationList("cOrE 3.0 xMl 3.0 eVeNts 2.0 lS");
         length = (int) domImplList.getLength();
      
      if (equals(0, length)) {
          baseImpl = getImplementation();
      hasCore = baseImpl.hasFeature("Core", "3.0");
hasXML = baseImpl.hasFeature("XML", "3.0");
hasEvents = baseImpl.hasFeature("Events", "2.0");
hasLS = baseImpl.hasFeature("LS", nullVersion);
assertFalse("baseImplFeatures", 
    (hasCore & hasXML & hasEvents & hasLS)
);
} else {
          for (int indexN10096 = 0; indexN10096 < domImplList.getLength(); indexN10096++) {
          domImpl = (DOMImplementation) domImplList.item(indexN10096);
    hasCore = domImpl.hasFeature("Core", "3.0");
assertTrue("hasCore", hasCore);
      hasXML = domImpl.hasFeature("XML", "3.0");
assertTrue("hasXML", hasXML);
      hasEvents = domImpl.hasFeature("Events", "2.0");
assertTrue("hasEvents", hasEvents);
      hasLS = domImpl.hasFeature("LS", nullVersion);
assertTrue("hasLS", hasLS);
        }
      }
        
    }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/domimplementationregistry23";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(domimplementationregistry23.class, args);
   }
}

