# ####################################################################################
# drag-robot dialog: helper function to display properties in better readable SI units
var guiUpdateDragRobot = func {
	# min. takeoff speed 
	if ( getprop("sim/glider/dragger/conf/glob_min_speed_takeoff_mps") == nil ) {
		var min_speed_takeoff = 20 * 3.6;
	}
	else {
		var min_speed_takeoff = getprop(
			"sim/glider/dragger/conf/glob_min_speed_takeoff_mps") * 3.6;
	}
	setprop("sim/glider/gui/dragrobot/min_speed_takeoff", min_speed_takeoff);
	
	# max. speed 
	if ( getprop("sim/glider/dragger/conf/glob_max_speed_mps") == nil ) {
		var max_speed = 36 * 3.6;
	}
	else {
		var max_speed = getprop("sim/glider/dragger/conf/glob_max_speed_mps") * 3.6;
	}
	setprop("sim/glider/gui/dragrobot/max_speed", max_speed);
	
	# max. tauten speed 
	if ( getprop("sim/glider/dragger/conf/glob_max_speed_tauten_mps") == nil ) {
		var max_speed_tauten = 3 * 3.6;
	}
	else {
		var max_speed_tauten = getprop(
			"sim/glider/dragger/conf/glob_max_speed_tauten_mps") * 3.6;
	}
	setprop("sim/glider/gui/dragrobot/max_speed_tauten", max_speed_tauten);
	
}


# ####################################################################################
# drag-robot dialog: helper function to run the roboter, avoiding race conditions
var guiRunDragRobot = func {
	asw20.findDragger();    
	asw20.hookDragger();    
	asw20.startDragRobot();
}


# ####################################################################################
# drag-robot dialog: helper function to cancel the roboter, avoiding race conditions
var guiCancelDragRobot = func {
	asw20.removeDragRobot();
	asw20.resetRobotAttributes();
	asw20.removeTowingRope();
}


var guidragrobotinit = setlistener("sim/signals/fdm-initialized", 
				   guiUpdateDragRobot,,0);
var guidragrobot_1   = setlistener("sim/glider/dragger/conf/glob_min_speed_takeoff_mps", 
				   guiUpdateDragRobot,,0);
var guidragrobot_2   = setlistener("sim/glider/dragger/conf/glob_max_speed_mps", 
				   guiUpdateDragRobot,,0);
var guidragrobot_3   = setlistener("sim/glider/dragger/conf/glob_max_speed_tauten_mps", 
				   guiUpdateDragRobot,,0);

