> _Cessna 208B Grand Caravan for FlightGear, the free and open-source flight simulator_<br/>
> _Manual by ePilot, updated and converted to markdown by Bea Wolf_

#   CESSNA 208B FLIGHT OPERATIONS MANUAL
*for flight simulation use only*

<img src="../Previews/exterior1.jpg" alt="drawing" width="500"/>

The Cessna 208B ‘Grand Caravan’ began as the 208 project which commenced on
November 20, 1981, and the prototype first flew on December 9, 1982. The production
model was certified by the FAA in October 1984 and its Cargomaster freighter variant
was developed for FedEx. The 4 ft (1.2 m) longer 208B Super Cargomaster first flew in
1986 and was developed into the passenger 208B Grand Caravan.

<br/>

| Dimensions        | Performance*           | Weight and Limits      |
|-------------------|------------------------|------------------------|
|Wingspan 52'1''    | Ground Roll: 1,399 ft  | Empty: 5,301 lbs       |
|Wing Area 279 sq ft| Max Climb: 1,330 ft/min| Max TO Water: 8,807 lbs|
|Length: 41'7''     | Max Cruise: 195 ktas   | Max TO Land: 8,807 lbs |
|Height: 15’ 1”     | Max Range: 964 nm      | Useful Load: 3,692 lbs |
|Engine: PT6A-114A  | * less with cargo pod  | w/cargo pod: 3,532 lbs |

<br/>
<hr/>
##   Features
### Configuration Options
The Cessna 208B includes many configuration options, all of which are available by
loading a single aircraft. The set file name is C208B-set.xml. Loading from the command
line can be accomplished using the command line option –aircraft-C208B.
### Instrument Panel Options
This aircraft is equipped with 2 complete 3D instrument panels. The first and default is
the original equipment “Steam Gauge” panel. The second is a Garmin G1000 glass panel
upgrade.
To switch between the different panels, select the different variants on start-up.
### Amphibious Operations
The aircraft will determine where it is being loaded and will configure itself
appropriately. 

| Location | Landing Gear | Parking Brake | Floats |
|---|---|---|---|
| Loading at a Seaplane Base (on the water)| Landing Gear Up | Parking Brake Off | Floats Attached | 
| Loading at a land based Airport          | Tricycle Gear   | Parking Brake Set.  | Floats Removed| 

These options are, of course, manually configurable at any time, however the
aircraft will not allow you to do anything disastrous, i.e. removing the floats while being
supported by them on water.

##   Key Reference
Knowing these shortcut keys will aid in learning the Cessna-208B and add to your flying
enjoyment.

| Key | Command |
|-----|---------|
|<kbd>Alt</kbd>+<kbd>M</kbd>|Toggle Map|
|<kbd>F11</kbd>|Autopilot Dialog|
|<kbd>F12</kbd>|Radio Dialog|
|<kbd>Y</kbd>|Show/Hide Yokes|
|<kbd>U</kbd>|Raise Pilot Seat|
|<kbd>Shift</kbd>+<kbd>U</kbd>|Lower Pilot Seat|
|<kbd>Ctrl</kbd>+<kbd>U</kbd>|Reset Pilot Seat Height|
|<kbd>Ctrl</kbd><kbd>A</kbd>|Toggle Auto-Coordination|
|<kbd>F</kbd>|Toggle Floats|
|<kbd>R</kbd>|Raise/Lower Water Rudders|
|<kbd>G</kbd>|Raise/Lower Amphibian Landing Gear|
|<kbd>C</kbd>|Toggle Cargo Configuration|
|<kbd>J</kbd>|Toggle Skydiving ("Jumpship") Configuration|
|<kbd>S</kbd>|Move Starter Switch Forward|
|<kbd>Shift</kbd>+<kbd>S</kbd>|Move Starter Switch Aft|

##   Procedures
### Engine Startup

* Battery Switch ON *(two-position toggle switch)*
* Fuel Boost Pump ON *(three-position switch OFF - NORM - ON)*
* Starter Switch ON *(three-position switch MOTOR - OFF - ON)*
> **Explanation:**  In the ON position the starter motor is engaged AND the engine ignitors are energized allowing the engine to start when fuel is introduced at the correct N1 speed. In the MOTOR position, the starter motor is engaged but the ignitors are NOT energized. The engine will turn over but it will not start.
* Add Fuel when N1 > 15% *(move Fuel Condition Lever to LOW IDLE)*
* Starter Switch OFF when N1 > 20%
* Fuel Boost Pump NORM

## Active Livery System
The active livery system will reconfigure your aircraft as appropriate for the livery you choose.
It will NOT make any unsafe changes, (i.e. removing floats if you are currently floating on
them). There are currently 4 fuselage configuration options available and can be used in any
combination.

*  **Passenger / Cargomaster configuration:** The passenger fuselage includes windows and
seating, the cargomaster does not. Toggle the Cargomaster configuration with the ***C*** key
*  **Tricycle Gear / Floats:** Toggle this fuselage configuration option with ***F*** key. The system will not allow you to remove the floats if you are currently being supported by them on water.
Doing so would, of course, have very unpleasant consequences.
*  **Sky-Diving Configuration:** This configuration removes the passenger seating and cabin doors to allow skydivers easy exit from the aircraft. This configuration can be toggled with the ***J*** key.
*  **Cargo Tank:** The cargo tank can be installed or removed. There is currently no hotkey for this
operation but it is accessible from the ***Cessna-208B Menu***.

The active livery system uses **four properties** (found near the top of each livery .xml file) to
function which you can add to any livery you create or you can modify existing liveries to your
liking. If these properties are omitted from the livery xml file then no configuration changes
will be made other than changing the livery.

* **float-command:** set to 1 or true to add floats, 0 or false to remove floats
* **cargo:** set to 1 or true to use Cargomaster fuselage, 0 or false to use Passenger configuration
* **cargo-pod:** set to 1 or true to attach the cargo tank, 0 or false to remove the Cargo Tank
* **jumpship:** set to 1 or true to enable the Skydiving fuselage configuration, 0 or false to disable

## Amphibious Operations
This aircraft is equipped with the **WipAire 8750 Float package** including **retractable gear** and **Laser Gear Advisory System.** The entire float package can be installed/removed at any time (unless you are currently floating on them) simply by tapping the ***F*** key. The installation of floats is automatic if you load at a seaplane base (on water).

### Water taxiing
Lower (and raise) the float rudders with the ***R*** key. With the float rudders lowered you will have
excellent control of the aircraft for taxiing. <br/>
**DO NOT Takeoff or Touch Down with float rudders lowered!** In addition to damaging the aircraft this will likely kill you. Use the float rudders to get lined up for takeoff, raise them, then perform your takeoff. Use the flight control rudder to maintain heading on your takeoff run. <br/>
Limit your use of float rudders to speeds less that 10-15 kts.

Lowering of the gear while on the water is permitted to perform amphibious operations BELOW 10-15 kts.
Lowering the gear at higher speeds has very unpleasant side effects. **Landing on water with the gear down will flip the aircraft!**

### Land taxiing
Contrary to the standard tricycle gear of the Cessna 208B the float nosewheels are **NOT steerable - they are castering**. Be prepared to steer with **differential main wheel braking.**

## Wipaire Laser Gear Advisory System
At about 400 feet above ground level the Laser Gear Advisory begins detecting if you are over a water or land surface. After detecting the surface a light illuminates on the gear advisory display indicating either land or water surface. If the current gear configuration does NOT match the
detected surface a warning light illuminates with the word **GEAR**.
<br/>

|  | On/Over Water | On/Over Land |
|--|--|--|
| **Gear Up** | <img src="amphib-gear-wu" width="300"/> | <img src="amphib-gear-lu" width="300"/>|
| **Gear Down** | <img src="amphib-gear-wd" width="300"/>| <img src="amphib-gear-ld" width="300"/>|

