##################################################################
####      bogeycontrol.nas - ePilot                           ####
####                                                          ####
####    Main Float Bogey management. Controls initial load    ####
####    fuselage configuration and float bogey positioning,   ####
####    hydrodynamic drag, float side forces and              ####
####    float rudder forces                                   #### 
##################################################################

# moved a lot of FDM functions to a JSBSim system (Bea Wolf 2023)

var configbogeys = func {
	if( getprop("fdm/jsbsim/ground/solid") ){
		setprop("sim/model/floats", 0);
		setprop("/controls/gear/gear-down", 0);
	} else {
		setprop("sim/model/floats", 1);
		setprop("/controls/gear/gear-down", 0);
	}
}

setlistener("/sim/signals/fdm-initialized", configbogeys);

var manualconfig = func {
	
	if ( !getprop("/sim/model/floats") ) {
		
		# switching to floats
		var wow=getprop("/fdm/jsbsim/gear/wow");
		if (wow) {
			# if on ground raise the plane, raise water bogeys and lower the float gear
			setprop("/controls/gear/gear-down", 1);
			
			setprop("/fdm/jsbsim/position/h-agl-ft", getprop("/fdm/jsbsim/position/h-agl-ft") + 5);
		} else {
			# if in air just raise the float gear
			setprop("/controls/gear/gear-down", 0);
		}
		
		setprop("/sim/model/floats", 1);
		
	} else {
		
		# removing floats
		var floating=getprop("/fdm/jsbsim/contact/unit[18]/compression-ft");
		if (floating == 0) {
			setprop("sim/model/floats", 0);
		} else {
			setprop("sim/messages/copilot","We are curently using the floats captain - cannot remove");
		}
		
	}
	
}

setlistener("/sim/model/float-command", manualconfig, 0, 0);

##############################  water drag  #############################################


var bogeydrag = func {
	
	
	var running = getprop("/engines/engine[0]/running");
	
	if (running) {
		
		var speed = getprop("/velocities/groundspeed-kt");
		var throttle = getprop("/controls/engines/engine[0]/throttle");
		
		var coeff = (0.15 + (speed/500) - (throttle/3));
		
		# setprop("sim/messages/copilot", "Setting strucs to " ~ coeff);
		
		for (var struc=15; struc < 19; struc = struc + 1) {
			setprop("fdm/jsbsim/contact/unit[" ~ struc ~ "]/dynamic_friction_coeff", coeff);
		}
	}
	settimer(bogeydrag, 0.5);
}
bogeydrag();


##############################  water rudders  #############################################


var rudderboost = func {
	
	
	var onleftfloat = getprop("/gear/gear[17]/compression-ft");
	var onrightfloat = getprop("/gear/gear[18]/compression-ft");
	
	if (onleftfloat and onrightfloat) {
		
		var wrudders = getprop("/controls/gear/wrudders");
		
		if (wrudders) {
			var speed = getprop("/velocities/groundspeed-kt");
			var targetvar = 20 - (speed / 1.8);
			if (targetvar < 1) { targetvar = 1; }
			setprop("fdm/jsbsim/fcs/yaw-hydro", targetvar);
		} else {
			setprop("fdm/jsbsim/fcs/yaw-hydro", 1);
		}
	}
	settimer(rudderboost, 0.5);
	
}
rudderboost();

