# DHC-8-100/200/300 ID-802 Advisory Display by Bea Wolf based on
# A3XX Lower ECAM Canvas by Joshua Davidson (Octal450)

# References: see id-802.xml

var id802_main = nil;
var id802_display = nil;

var volts_property = props.globals.getNode("/systems/electrical/outputs/advsy[0]", 1); # TODO Left/Right Display feed from advsy[0]/advsy[1]

var sat = props.globals.getNode("/environment/temperature-degc");
var tas = props.globals.getNode("/instrumentation/airspeed-indicator/true-speed-kt", 1);

var sat_tas = props.globals.initNode("/instrumentation/id-802[0]/sat-tas", 0, "BOOL"); # 0 = sat (default), 1 = tas (TAS switchlight pressed, momentary action)

var canvas_id802_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Regular.ttf";
		};

		canvas.parsesvg(canvas_group, file, {"font-mapper": font_mapper});

		var svg_keys = me.getKeys();
		
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if ( volts_property.getDoubleValue() > 15.0 ) {
			id802_main.page.show();
			id802_main.update();
		} else {
			id802_main.page.hide();
		}
	},
};

var canvas_id802_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_id802_main,canvas_id802_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [ "sat_tas" ];
	},
	update: func() {	
		if( !sat_tas.getBoolValue() ){
			# Default: Show SAT
			me["sat_tas"].setText( sprintf("%+2d", math.round( sat.getDoubleValue() ) ) ~"c SAT" );
		} else {
			# TAS Switchlight pressed: Show TAS
			me["sat_tas"].setText( sprintf("%3d", math.round( tas.getDoubleValue() ) ) ~" TAS" );
		}
	},
};

var id802_update = maketimer( 0.1, func(){ canvas_id802_base.update() } );
id802_update.simulatedTime = 1;

setlistener("sim/signals/fdm-initialized", func {
	id802_display = canvas.new({
		"name": "ID-802",
		"size": [640, 256],
		"view": [640, 256],
		"mipmapping": 1
	});
	id802_display.addPlacement({"node": "id_802.display"});

	id802_main = canvas_id802_main.new(id802_display.createGroup(), "Aircraft/DHC-8/Models/Cockpit/Instruments/ID-802/id-802-display.svg");

	id802_update.start();
});
