##################################################################
#
# Gust Configurator: Specify gust
#
##################################################################

var GustConfigurator = func {

  var gust_magnitude_mps = getprop("sim/model/GustConfigurator/gust-magnitude-mps");
  var gust_magnitude_fps = gust_magnitude_mps* M2FT;

  var gust_alpha_deg = getprop("sim/model/GustConfigurator/gust-alpha-deg");
  var gust_alpha_rad = gust_alpha_deg * D2R;

  var gust_beta_deg = getprop("sim/model/GustConfigurator/gust-beta-deg");
  var gust_beta_rad = gust_beta_deg * D2R;

  var gust_z = -math.sin( gust_alpha_rad );
  var gust_x = -math.cos( gust_alpha_rad );
  
  var gust_y = -math.sin( gust_beta_rad );

  setprop("fdm/jsbsim/atmosphere/cosine-gust/startup-duration-sec", getprop("sim/model/GustConfigurator/startup-duration-sec") );
  setprop("fdm/jsbsim/atmosphere/cosine-gust/steady-duration-sec",  getprop("sim/model/GustConfigurator/steady-duration-sec") );
  setprop("fdm/jsbsim/atmosphere/cosine-gust/end-duration-sec",     getprop("sim/model/GustConfigurator/end-duration-sec") );
  setprop("fdm/jsbsim/atmosphere/cosine-gust/magnitude-ft_sec", gust_magnitude_fps);
  setprop("fdm/jsbsim/atmosphere/cosine-gust/frame", getprop("sim/model/GustConfigurator/frame") );
  setprop("fdm/jsbsim/atmosphere/cosine-gust/X-velocity-ft_sec", gust_x);
  setprop("fdm/jsbsim/atmosphere/cosine-gust/Y-velocity-ft_sec", gust_y);
  setprop("fdm/jsbsim/atmosphere/cosine-gust/Z-velocity-ft_sec", gust_z);

  if(getprop("sim/model/GustConfigurator/gust-start")){
    setprop("fdm/jsbsim/atmosphere/cosine-gust/start", 1);
  }

}
