# King KFC250 Autopilot

*References:	see instruments.md*

## Physical Parts:
* KC290/291: Control Panel
* KCP299: Computer
* Servos (Pitch, Roll, Yaw and Pitch Trim)
* Yoke Control Buttons:
	* CWS (Control Wheel Steering)
	* AP DISC (Autopilot Disconnect)
* Power Lever Buttons:
	* GA (Go Around)
* other parts normally installed (KI525A NAV, KI256 FD, KEA346, ...) are integrated into the EFI

## Parts:
* Flight Director (FD)
	* provides commands to the pilot (via FD bars on the PFD) and to the autopilot
* Autopilot (AP)
* Yaw Damper (YD)
	* automatically activated along with the autopilot when autopilot is switched on
	
## Modes:
### Lateral

|	Mode		|	Engaged by	|	Description																|
|-----------------------|-----------------------|-----------------------------------------------------------------------------------------------------------------------------------------------|
| Wings Level		|	FD and GA Press	|	Commands wings level															|
| HDG (Heading)		|	HDG Press	|	Turns to and maintains the commanded heading (selected via the CHP (Course Heading Panel) on the glareshield panel to the EFI-890R)	|
| NAV (Navigate)	|	NAV Press	|	HDG Mode with NAV Mode until capture point (?), then captures and holds NAV/RNAV							|
| APPR (Approach)	|	APPR Press	|	in case of VOR: like NAV mode; in case of LOC/GS: like NAV mode, but also captures GS (Glideslope)					|
| BC (Back Course)	|	BC Press	|	along with APPR mode: captures reverse localizer											|

### Vertical

|	Mode		|	Engaged by	|	Description																|
|-----------------------|-----------------------|-----------------------------------------------------------------------------------------------------------------------------------------------|
| Pitch			|	GA Press	|	Commands a set pitch attitude, secondarily used by ALT HOLD										|
| ALT HOLD		|	ALT Press	|	Commands the pitch attitude to hold a set altitude, when ALT is slewed using the FD/AP Vertical Trim Climbs/Descends max.600fpm		|
