// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v2alpha1 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCiliumCIDRGroups implements CiliumCIDRGroupInterface
type FakeCiliumCIDRGroups struct {
	Fake *FakeCiliumV2alpha1
}

var ciliumcidrgroupsResource = v2alpha1.SchemeGroupVersion.WithResource("ciliumcidrgroups")

var ciliumcidrgroupsKind = v2alpha1.SchemeGroupVersion.WithKind("CiliumCIDRGroup")

// Get takes name of the ciliumCIDRGroup, and returns the corresponding ciliumCIDRGroup object, and an error if there is any.
func (c *FakeCiliumCIDRGroups) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2alpha1.CiliumCIDRGroup, err error) {
	emptyResult := &v2alpha1.CiliumCIDRGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewRootGetActionWithOptions(ciliumcidrgroupsResource, name, options), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.CiliumCIDRGroup), err
}

// List takes label and field selectors, and returns the list of CiliumCIDRGroups that match those selectors.
func (c *FakeCiliumCIDRGroups) List(ctx context.Context, opts v1.ListOptions) (result *v2alpha1.CiliumCIDRGroupList, err error) {
	emptyResult := &v2alpha1.CiliumCIDRGroupList{}
	obj, err := c.Fake.
		Invokes(testing.NewRootListActionWithOptions(ciliumcidrgroupsResource, ciliumcidrgroupsKind, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v2alpha1.CiliumCIDRGroupList{ListMeta: obj.(*v2alpha1.CiliumCIDRGroupList).ListMeta}
	for _, item := range obj.(*v2alpha1.CiliumCIDRGroupList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested ciliumCIDRGroups.
func (c *FakeCiliumCIDRGroups) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchActionWithOptions(ciliumcidrgroupsResource, opts))
}

// Create takes the representation of a ciliumCIDRGroup and creates it.  Returns the server's representation of the ciliumCIDRGroup, and an error, if there is any.
func (c *FakeCiliumCIDRGroups) Create(ctx context.Context, ciliumCIDRGroup *v2alpha1.CiliumCIDRGroup, opts v1.CreateOptions) (result *v2alpha1.CiliumCIDRGroup, err error) {
	emptyResult := &v2alpha1.CiliumCIDRGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateActionWithOptions(ciliumcidrgroupsResource, ciliumCIDRGroup, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.CiliumCIDRGroup), err
}

// Update takes the representation of a ciliumCIDRGroup and updates it. Returns the server's representation of the ciliumCIDRGroup, and an error, if there is any.
func (c *FakeCiliumCIDRGroups) Update(ctx context.Context, ciliumCIDRGroup *v2alpha1.CiliumCIDRGroup, opts v1.UpdateOptions) (result *v2alpha1.CiliumCIDRGroup, err error) {
	emptyResult := &v2alpha1.CiliumCIDRGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateActionWithOptions(ciliumcidrgroupsResource, ciliumCIDRGroup, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.CiliumCIDRGroup), err
}

// Delete takes name of the ciliumCIDRGroup and deletes it. Returns an error if one occurs.
func (c *FakeCiliumCIDRGroups) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(ciliumcidrgroupsResource, name, opts), &v2alpha1.CiliumCIDRGroup{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCiliumCIDRGroups) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionActionWithOptions(ciliumcidrgroupsResource, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v2alpha1.CiliumCIDRGroupList{})
	return err
}

// Patch applies the patch and returns the patched ciliumCIDRGroup.
func (c *FakeCiliumCIDRGroups) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumCIDRGroup, err error) {
	emptyResult := &v2alpha1.CiliumCIDRGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceActionWithOptions(ciliumcidrgroupsResource, name, pt, data, opts, subresources...), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v2alpha1.CiliumCIDRGroup), err
}
