---
title: Getting involved
description: Contribute to Calico open source project.
canonical_url: '/reference/involved'
---

Calico is an open source project, and we'd love you to get involved.
Whether that might be by reading and participating on our slack,
or by diving into the code to propose enhancements or integrate with
other systems. To see the options for getting involved with Calico the
project, please take a look at the following.

## Join us on Slack

Our [public slack](https://slack.projectcalico.org){:target="_blank"} is the quickest way to get
in touch for help debugging any issues with Calico.

## Read the source, Luke!

All of Calico's code is on [GitHub](https://github.com/projectcalico){:target="_blank"}.  The following
list contains the most commonly encountered repositories:

Repository                                                              | Description
------------------------------------------------------------------------|----------------------------
[Calico](https://github.com/projectcalico/calico){:target="_blank"}                       | Calico release artifacts and documentation
[calicoctl](https://github.com/projectcalico/calicoctl){:target="_blank"}                 | calicoctl CLI tool
[cni-plugin](https://github.com/projectcalico/cni-plugin){:target="_blank"}               | Calico CNI plugin
[felix](https://github.com/projectcalico/felix){:target="_blank"}                         | felix policy enforcement agent
[kube-controllers](https://github.com/projectcalico/kube-controllers){:target="_blank"}   | Kubernetes controllers
[libcalico-go](https://github.com/projectcalico/libcalico-go){:target="_blank"}           | Golang Calico library

## Contributing

Calico follows the "Fork & Pull" model of collaborative development,
with changes being offered to the main Calico codebase via pull
requests. So you can contribute a fix, change, or enhancement by forking
one of our repositories and making a GitHub pull request. If you're
interested in doing that:

-   Thanks!
-   See the [GitHub docs](https://help.github.com/articles/using-pull-requests){:target="_blank"} for how
    to create a pull request.
-   Check the contribution guidelines at the root of each repo for more details.
