09 May 2022

#### User action required if upgrading to v3.23.0

 - The tigera-operator helm chart now requires the user pre-create the `tigera-operator` namespace, or pass the `--create-namespace` option to `helm install`. Additionally, there are specific upgrade steps that MUST be performed when upgrading a helm install to Calico v3.23. Please see [the helm upgrade documentation](https://projectcalico.docs.tigera.io/maintenance/kubernetes-upgrade#upgrading-an-installation-that-was-installed-using-helm) for instructions. [calico #5649](https://github.com/projectcalico/calico/pull/5649) (@caseydavenport)

#### IPv6 VXLAN support

Calico now supports VXLAN encapsulation for IPv6 networks.

Pull Requests:

 - Add IPv6 VXLAN support [calico #5988](https://github.com/projectcalico/calico/pull/5988) (@coutinhop)
 - Add IPv6 VXLAN route calculation support to Felix [calico #5919](https://github.com/projectcalico/calico/pull/5919) (@coutinhop)
 - Allocate IPv6 VXLAN tunnel addresses [calico #5893](https://github.com/projectcalico/calico/pull/5893) (@coutinhop)

#### VPP dataplane beta

The Calico VPP dataplane integration has reached beta status! Over the last few releases, the VPP team has made great strides in increasing stability, performance and feature compatibility.

#### Calico networking support in AKS

You can now use Calico networking in your AKS clusters to take advantage of all of the Calico networking features.
To try it out, follow the Calico on AKS [installation instructions]({{site.baseurl}}/getting-started/kubernetes/managed-public-cloud/aks#install-aks-with-calico-networking).
To learn more about using your own network plugin in AKS, see the [AKS documentation](https://docs.microsoft.com/en-us/azure/aks/use-byo-cni?tabs=azure-cli).

Pull Requests:

 - Updated Calico doc for AKS bring Your Own CNI. [calico #5857](https://github.com/projectcalico/calico/pull/5857) (@song-jiang)

#### BGP enhancements

We have added configuration options for turning off loop prevention so that any Calico nodes in separate clusters or sites can exchange routes even if they share
the same AS. To cut down on graceful restart race conditions, we have also added the ability to configure the max restart time and BGP password for full mesh BGP
configurations. If you are using specific global BGP peers instead of a full mesh, we have added logic to detect when the peer is another Calico instance and add
in the passive configuration appropriately to further cut down on graceful restart race conditions.

Pull Requests:

 - Add BGP configuration options for turning off BGP loop prevention for eBGP peers. [calico #5736](https://github.com/projectcalico/calico/pull/5736) (@mgleung)
 - Add passive configuration for global BGP peers [calico #5625](https://github.com/projectcalico/calico/pull/5625) (@mgleung)
 - Add maxRestartTime and BGP password fields to BGP configurations for full mesh configurations. [calico #5609](https://github.com/projectcalico/calico/pull/5609) (@mgleung)

#### Container Storage Interface (CSI) support

Following the Kubernetes move from FlexVolumes, Calico now has its own CSI driver. Features that used to depend on FlexVolumes have been migrated to instead use CSI. To upgrade
to use the CSI driver, follow the feature's installation instructions again (e.g. [application layer policy installation instructions]({{site.baseurl}}/security/app-layer-policy)).

Pull Requests:

 - Replace the use of the flexvolume driver with a CSI driver [calico #5863](https://github.com/projectcalico/calico/pull/5863) (@mgleung)

#### Windows HostProcess Containers Support (Tech Preview)

You can now install Calico on Windows using [HostProcess containers](https://kubernetes.io/docs/tasks/configure-pod-container/create-hostprocess-pod/).
With HostProcess containers, you can manage your Calico installation using Kubernetes resources, such as DaemonSets and ConfigMaps. To try it for yourself,
follow the [Calico for Windows installation instructions]({{site.baseurl}}/getting-started/windows-calico/quickstart#install-calico-for-windows-using-hostprocess-containers).

Pull Requests:

 - Add tech-preview support for Calico for Windows using HostProcess containers [calico #5864](https://github.com/projectcalico/calico/pull/5864) (@lmm)

#### Bug fixes

##### General

 - Fix race condition in BIRD that could potentially cause missed config updates [bird #101](https://github.com/projectcalico/bird/pull/101) (@pluzun)
 - Fix a bug where the check for treating the 240/4 CIDR like RFC 1918 ranges caught the broadcast address 255.255.255.255 [bird #100](https://github.com/projectcalico/bird/pull/100) (@gmavrikas)
 - Handle bootstrapping of Wireguard to ensure felix is able to connect to typha. This fixes a bug that is present when HostEncryptionEnabled is set to true (which is required for using wireguard with AKS). Previously, when nodes shared their wireguard public keys, depending on the order they keys were shared, it was possible to end up with asymmetric node-to- node routing. Packets will be dropped between impacted nodes. If the typha nodes are impacted then it is possible for other nodes to be effectively locked out from connecting to typha and the routing issue will persist. This will be apparent through persistent readiness checks failing on the node. [calico #5869](https://github.com/projectcalico/calico/pull/5869) (@robbrockbank)
 - IPAM block GC now respects the leak grace period instead of immediately deleting blocks. [calico #5812](https://github.com/projectcalico/calico/pull/5812) (@caseydavenport)
 - Fix potential panic in CNI plugin due to conflicting host routes [calico #5780](https://github.com/projectcalico/calico/pull/5780) (@luobily)
 - Calico's install-cni command now fails in case the directory is not writeable. [calico #5806](https://github.com/projectcalico/calico/pull/5806) (@turekt)
 - Rework Felix's interface monitoring logic.  Fixes a couple of bugs where interface state changes wouldn't be noticed: kube-proxy being switched ti IPVS mode could go unnoticed; BPF mode would sometimes fail to clean up status tracking files when an interface was removed. [calico #5776](https://github.com/projectcalico/calico/pull/5776) (@fasaxc)
 - Fix that Felix logs would sometimes record <nil> for the filename of some logs. [calico #5726](https://github.com/projectcalico/calico/pull/5726) (@fasaxc)
 - Prevent IPAM GC when datastore is locked [calico #5676](https://github.com/projectcalico/calico/pull/5676) (@Icarus9913)
 - Fix that Typha would periodically disconnect clients in clusters with more than 100 nodes per Typha due to miscalculating the expected number of connections. [calico #5662](https://github.com/projectcalico/calico/pull/5662) (@fasaxc)
 - Fix a typecast bug preventing the parsing of route table ranges. [calico #5652](https://github.com/projectcalico/calico/pull/5652) (@mikestephen)
 - Fix bug that prevented endpoint ipsets from being updated if the labels were empty values. [calico #5624](https://github.com/projectcalico/calico/pull/5624) (@lmm)
 - IPAM garbage collector properly releases IP addresses whose handles have been deleted [calico #5613](https://github.com/projectcalico/calico/pull/5613) (@caseydavenport)
 - Add backoff to Kubernetes watch loops to avoid tight looping in certain failure scenarios. [calico #5562](https://github.com/projectcalico/calico/pull/5562) (@fasaxc)
 - Fix dynamic build of pod2daemon which resulted in cryptic "no such file or directory" errors [calico #5515](https://github.com/projectcalico/calico/pull/5515) (@caseydavenport)
 - Fix garbage collection of empty blocks during flannel migration [calico #5459](https://github.com/projectcalico/calico/pull/5459) (@squ94wk)
 - Fix a bug causing deadlocking in host encryption enabled clusters using wireguard when nodes are restarted. [calico #5280](https://github.com/projectcalico/calico/pull/5280) (@aaaaaaaalex)

##### eBPF dataplane

 - ebpf: Fixes issue with IPIP tunnels on kernels 5.14+ and RH kernels 4.18.0-330.el8+ as the tunnel device started behaving as a proper L3 device. [calico #5846](https://github.com/projectcalico/calico/pull/5846) (@mazdakn)
 - epbf: Fixed in bug in ICMP connection tracking [calico #5792](https://github.com/projectcalico/calico/pull/5792) (@tomastigera)
 - ebpf: Fixed reusing stale conntrack TCP entries. [calico #5804](https://github.com/projectcalico/calico/pull/5804) (@tomastigera)
 - ebpf: Fix that policy would see 0.0.0.0:0 as the post-nat destination for SYN packets that had a conntrack hit. [calico #5768](https://github.com/projectcalico/calico/pull/5768) (@tomastigera)
 - ebpf: Fixed unconnected udp affinity - avoids be selection for each packet. [calico #5617](https://github.com/projectcalico/calico/pull/5617) (@tomastigera)

##### Windows

 - Fix Calico for Windows install script not enabling WinDSR on EKS [calico #5903](https://github.com/projectcalico/calico/pull/5903) (@lmm)
 - Fix invalid parameter to prevented DSR enablement from being passed to kube-proxy in Windows. [calico #5710](https://github.com/projectcalico/calico/pull/5710) (@lmm)
 - Fix windows kube-proxy config incompatible with k8s 1.23 [calico #5653](https://github.com/projectcalico/calico/pull/5653) (@lmm)


#### Other changes

##### General

 - Operator monitors BGP configuration resource to trigger rolling updates as needed [calico #6017](https://github.com/projectcalico/calico/pull/6017) (@caseydavenport)
 - go version update to 1.17.9 [calico #6002](https://github.com/projectcalico/calico/pull/6002) (@doublek)
 - Attach SHA256SUMS as part of release, including checksums for all release artifacts. [calico #5964](https://github.com/projectcalico/calico/pull/5964) (@caseydavenport)
 - Update to CNI plugins v1.1.1 [calico #5944](https://github.com/projectcalico/calico/pull/5944) (@caseydavenport)
 - Helm chart allows configuration of tigera-operator resource requirements. [calico #5934](https://github.com/projectcalico/calico/pull/5934) (@sriramy)
 - Add defensive checks to CNI plugin installer to improve reliability. [calico #5905](https://github.com/projectcalico/calico/pull/5905) (@caseydavenport)
 - Increase Typha's "max fall behind" timeout to 300s.  This means that Typha will keep up to 300s of history if needed instead of 90s (thus increasing RAM usage if clients are falling a bit behind) but it reduces the chance of disconnecting a client spuriously in a very large cluster. [calico #5885](https://github.com/projectcalico/calico/pull/5885) (@fasaxc)
 - Add Felix configuration option for programming floating IPs. [calico #5861](https://github.com/projectcalico/calico/pull/5861) (@caseydavenport)
 - Produce both static and dynamic builds of the Calico CNI plugin, fixes compatibility with systems that do not include glibc. [calico #5826](https://github.com/projectcalico/calico/pull/5826) (@caseydavenport)
 - Add Felix configuration option to disable RPF check for specific workloads. [calico #5742](https://github.com/projectcalico/calico/pull/5742) (@AloysAugustin)
 - Felix now supports setting the source address hint for workload routes separately for both IPv4 and IPv6 via the DeviceRouteSourceAddress and DeviceRouteSourceAddressIPv6 config params.  This allows for the IP address that kubelet uses to connect to a local pod to be controlled. [calico #5728](https://github.com/projectcalico/calico/pull/5728) (@hanamantagoudvk)
 - New per-pool IPAM metrics added [calico #5706](https://github.com/projectcalico/calico/pull/5706) (@pasanw)
 - Move PodDisruptionBudget from apiVersion policy/v1beta1 to policy/v1 [calico #5667](https://github.com/projectcalico/calico/pull/5667) (@coutinhop)
 - Update flannel to version v0.15.1 [calico #5578](https://github.com/projectcalico/calico/pull/5578) (@cyclinder) [calico #5640](https://github.com/projectcalico/calico/pull/5640) (@caseydavenport)
 - Felix now uses the existing IP Pools to determine whether the IPIP and/or VXLAN encapsulations should be enabled. Felix now cleans up IP addresses from the `tunl0` interface if IPIP is implicitly disabled. It leaves those addresses on the interface if IPIP is explicitly disabled via the default FelixConfiguration. [calico #5576](https://github.com/projectcalico/calico/pull/5576) (@coutinhop)
 - Calico install documentation now uses operator-based instructions by default [calico #5564](https://github.com/projectcalico/calico/pull/5564) (@caseydavenport)
 - Switch to centos stream8 [calico #5550](https://github.com/projectcalico/calico/pull/5550) (@fasaxc)
 - Kubernetes dependencies are updated from v0.21.8 to v0.21.9. [calico #5493](https://github.com/projectcalico/calico/pull/5493) (@ialidzhikov)
 - We have removed ancient migration code for migrating from Calico v1 format data stored in an etcd v2 datastore - i.e. from a Calico installation **before v3.0**.  There was already nothing in Calico's code or docs to provide a frontend/UI/CLI/whatever for using that code, and it's exceeding unlikely that it had any remaining usefulness. [calico #5488](https://github.com/projectcalico/calico/pull/5488) (@neiljerram)
 - Update the ipset package from 7.1 to 7.11 [calico #5485](https://github.com/projectcalico/calico/pull/5485) (@song-jiang)
 - Add DataplaneWatchdogTimeout configuration parameter to Felix to allow the watchdog timeout to be increased.  Prevents spurious liveness failures on heavily loaded systems or systems operating at very high pod scale.  Increase default timeout to 90s (from 20s) after seeing too many issues where the liveness check failed spuriously. [calico #5484](https://github.com/projectcalico/calico/pull/5484) (@fasaxc)
 - Add liveness callback to routing table updates to ensure watchdog doesn't time out when handling large numbers of updates. [calico #5483](https://github.com/projectcalico/calico/pull/5483) (@fasaxc)
 - Downgrade watchercache.go log to debug level to reduce log spam [calico #5470](https://github.com/projectcalico/calico/pull/5470) (@caseydavenport)
 - Rev up etcd to 3.5.1, k8s to v1.23.1/v0.23.1, and github.com/containernetworking/plugins and github.com/containernetworking/cni to v1.0.1. [calico #5466](https://github.com/projectcalico/calico/pull/5466) (@Aceralon)
 - proxy_delay setting failure should not be a critical error [calico #5453](https://github.com/projectcalico/calico/pull/5453) (@cyclinder)
 - Deprecated config arg `routeTableRange` in favour of `routeTableRanges`. Felix can now make use of a larger set of Linux route-tables, and can be configured to avoid sensitive ranges. This implicitly drops support for very old Linux kernels (below v2.6) [calico #5432](https://github.com/projectcalico/calico/pull/5432) (@aaaaaaaalex)
 - Switch to protobuf for Kubernetes API calls [calico #5409](https://github.com/projectcalico/calico/pull/5409) (@l1b0k)
 - Added 'readiness_gates' config to the CNI plugin, which will make it wait for the configured endpoints to be ready before launching the pod. [calico #5399](https://github.com/projectcalico/calico/pull/5399) (@VivekThrivikraman-est)
 - Wireguard PersistentKeepAlive enabled by default and wireguardKeepAlive parameter added to control PersistentKeepAlive option. [calico #5338](https://github.com/projectcalico/calico/pull/5338) (@makhov)
 - Allow configuration of bind mode via the BGPConfiguration API [calico #5279](https://github.com/projectcalico/calico/pull/5279) (@hanamantagoudvk)

##### eBPF dataplane
 - ebpf - workloads no longer adjust pmtu when FIB fails due to mtu check - the check is not needed anymore. [calico #5937](https://github.com/projectcalico/calico/pull/5937) (@sridhartigera)
 - ebpf: Add feature detection and also feature detection override in bpf data plane, similar to iptables. This allows to govern whether IPIP device is L3 or not. [calico #5929](https://github.com/projectcalico/calico/pull/5929) (@mazdakn)
 - ebpf - strict RPF enforced on workloads fully in BPF regardless of the workloads interface settings. [calico #5923](https://github.com/projectcalico/calico/pull/5923) (@tomastigera)
 - ebpf: Faster forwarding on CO-RE enabled kernels 5.7+ [calico #5822](https://github.com/projectcalico/calico/pull/5822) (@tomastigera)
 - Felix loads CO-RE enabled bpf programs in CO-RE capable kernels. That alows us to use  more recent bpf feature where available. Starts with proper testing whether a packet is GSO which should address some MTU related nodeport issues when the host is a KVM (use virtio) VM. [calico #5783](https://github.com/projectcalico/calico/pull/5783) (@sridhartigera)
 - ebpf: pod can connect to self when CTLB is disabled. [calico #5393](https://github.com/projectcalico/calico/pull/5393) (@tomastigera)
 - FELIX_BPFEnforceRPF=Disabled/Strict (Strict by default) enforces strict RPF regardless of device settings in BPF mode. [calico #5342](https://github.com/projectcalico/calico/pull/5342) (@tomastigera)

##### Windows

 - Windows install script now auto-detects networking backend via ippools [calico #6015](https://github.com/projectcalico/calico/pull/6015) (@lmm)
 - windows: use upstream pause image in the quickstart for nodes using Docker as their runtime [calico #5997](https://github.com/projectcalico/calico/pull/5997) (@lmm)
 - Add Windows DSR Loopback support [calico #5523](https://github.com/projectcalico/calico/pull/5523) (@jsturtevant)
