// Project Calico BPF dataplane programs.
// Copyright (c) 2020-2021 Tigera, Inc. All rights reserved.
// SPDX-License-Identifier: Apache-2.0 OR GPL-2.0-or-later

#ifndef __CALI_REASONS_H__
#define __CALI_REASONS_H__

enum calico_reason {
	CALI_REASON_UNKNOWN = 0x00,
	CALI_REASON_SHORT = 0x01,
	CALI_REASON_NOT_IP = 0xea,
	CALI_REASON_V6_WORKLOAD = 0x06,
	CALI_REASON_FAILSAFE = 0xfa,
	CALI_REASON_DNT = 0xd0,
	CALI_REASON_PREDNAT = 0xd1,
	CALI_REASON_POL = 0xbe,
	CALI_REASON_CT = 0xc0,
	CALI_REASON_BYPASS = 0xbb,
	CALI_REASON_CT_NAT = 0xc1,
	CALI_REASON_CSUM_FAIL= 0xcf,
	CALI_REASON_ENCAP_FAIL = 0xef,
	CALI_REASON_DECAP_FAIL = 0xdf,
	CALI_REASON_ICMP_DF = 0x1c,
	CALI_REASON_IP_OPTIONS = 0xeb,
	CALI_REASON_IP_MALFORMED = 0xec,
	CALI_REASON_UNAUTH_SOURCE = 0xed,
	CALI_REASON_RT_UNKNOWN = 0xdead,
	CALI_REASON_ACCEPTED_BY_XDP = 0xd9,
};

#endif /* __CALI_REASONS_H__ */
