16 Feb 2024

#### Bug fixes

 - Added retry mechanism to Windows version retrieval in install-cni to address possible panics when the OS is not ready. [calico #8466](https://github.com/projectcalico/calico/pull/8466) (@coutinhop)
 - ebpf: fixes possible holes in the list NAT backends if there is a terminating pod. [calico #8460](https://github.com/projectcalico/calico/pull/8460) (@tomastigera)
 - ebpf: fixed pods in nat-outgoing should not SNAT when accessing local host [calico #8458](https://github.com/projectcalico/calico/pull/8458) (@tomastigera)
 - ebpf: fixed leakage of nodeport healthcheck servers [calico #8457](https://github.com/projectcalico/calico/pull/8457) (@tomastigera)
 - ebpf: don't stumble on unknown prog types passed as int in json [calico #8456](https://github.com/projectcalico/calico/pull/8456) (@tomastigera)
 - Only program failsafe rules for IP version of the CIDR [calico #8455](https://github.com/projectcalico/calico/pull/8455) (@tomastigera)
 - Fix confd issues when running on Windows operator installations (using HPC). [calico #8422](https://github.com/projectcalico/calico/pull/8422) (@coutinhop)

#### Other changes

 - ebpf: alternative cgroup2 mount path can be specified by setting CALICO_CGROUP_PATH evn var for node. [calico #8512](https://github.com/projectcalico/calico/pull/8512) (@tomastigera)
 - Host MTU auto-detection now ignores interfaces that are down. [calico #8499](https://github.com/projectcalico/calico/pull/8499) (@fasaxc)
 - Bump iptables version of calico-node to 1.8.8 [calico #8485](https://github.com/projectcalico/calico/pull/8485) (@coutinhop)
 - Fix crypto UT after upgrading to golang v1.21.6 [calico #8478](https://github.com/projectcalico/calico/pull/8478) (@hjiawei)
 - ebpf: setting BPFExcludeIPsFromNAT allows node-local dns cache to work [calico #8473](https://github.com/projectcalico/calico/pull/8473) (@tomastigera)
 - Update runc [calico #8471](https://github.com/projectcalico/calico/pull/8471) (@Behnam-Shobiri)
 - Enable CGO for arm64 when building felix and node [calico #8470](https://github.com/projectcalico/calico/pull/8470) (@hjiawei)
 - ebpf: align defaultEndpointToHostAction with iptables - do not apply normal *-hep policy to wep [calico #8459](https://github.com/projectcalico/calico/pull/8459) (@tomastigera)
 - Felix now avoids accessing non-Calico IP sets. This reduces the scope for IP set compatibility errors when another app has created an IP set that Calico's version of IP set can't parse. [calico #8412](https://github.com/projectcalico/calico/pull/8412) (@mazdakn)
 - Remove spammy BIRD log about ignoring DOWN interfaces [calico #8401](https://github.com/projectcalico/calico/pull/8401) (@lbogdan)
 - Skip apiserver etcd3 healthcheck and disable profiling [calico #8396](https://github.com/projectcalico/calico/pull/8396) (@hjiawei)
