/*
 * Copyright (C) 2014-2020 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#if TARGET_OS_IPHONE
#if __has_include(<UIKit/_UITextSearching.h>)
#import <UIKit/_UITextSearching.h>
#endif
#endif

#import <WebKit/WKDataDetectorTypes.h>
#import <WebKit/WKWebView.h>
#import <WebKit/_WKActivatedElementInfo.h>
#import <WebKit/_WKAttachment.h>
#import <WebKit/_WKFindOptions.h>
#import <WebKit/_WKLayoutMode.h>
#import <WebKit/_WKOverlayScrollbarStyle.h>
#import <WebKit/_WKRenderingProgressEvents.h>

typedef NS_ENUM(NSInteger, _WKPaginationMode) {
    _WKPaginationModeUnpaginated,
    _WKPaginationModeLeftToRight,
    _WKPaginationModeRightToLeft,
    _WKPaginationModeTopToBottom,
    _WKPaginationModeBottomToTop,
} API_AVAILABLE(macos(10.10), ios(8.0));

typedef NS_OPTIONS(NSUInteger, _WKMediaCaptureStateDeprecated) {
    _WKMediaCaptureStateDeprecatedNone = 0,
    _WKMediaCaptureStateDeprecatedActiveMicrophone = 1 << 0,
    _WKMediaCaptureStateDeprecatedActiveCamera = 1 << 1,
    _WKMediaCaptureStateDeprecatedMutedMicrophone = 1 << 2,
    _WKMediaCaptureStateDeprecatedMutedCamera = 1 << 3,
} API_AVAILABLE(macos(10.13), ios(11.0));

typedef NS_OPTIONS(NSUInteger, _WKMediaMutedState) {
    _WKMediaNoneMuted = 0,
    _WKMediaAudioMuted = 1 << 0,
    _WKMediaCaptureDevicesMuted = 1 << 1,
    _WKMediaScreenCaptureMuted = 1 << 2,
} API_AVAILABLE(macos(10.13), ios(11.0));

typedef NS_OPTIONS(NSUInteger, _WKCaptureDevices) {
    _WKCaptureDeviceMicrophone = 1 << 0,
    _WKCaptureDeviceCamera = 1 << 1,
    _WKCaptureDeviceDisplay = 1 << 2,
} API_AVAILABLE(macos(10.13), ios(11.0));

typedef NS_OPTIONS(NSUInteger, _WKSelectionAttributes) {
    _WKSelectionAttributeNoSelection = 0,
    _WKSelectionAttributeIsCaret = 1 << 0,
    _WKSelectionAttributeIsRange = 1 << 1,
} API_AVAILABLE(macos(10.15), ios(13.0));

typedef NS_ENUM(NSInteger, _WKShouldOpenExternalURLsPolicy) {
    _WKShouldOpenExternalURLsPolicyNotAllow,
    _WKShouldOpenExternalURLsPolicyAllow,
    _WKShouldOpenExternalURLsPolicyAllowExternalSchemesButNotAppLinks,
} API_AVAILABLE(macos(12.0), ios(15.0));

#if TARGET_OS_IPHONE

typedef NS_ENUM(NSUInteger, _WKDragInteractionPolicy) {
    _WKDragInteractionPolicyDefault = 0,
    _WKDragInteractionPolicyAlwaysEnable,
    _WKDragInteractionPolicyAlwaysDisable
} API_AVAILABLE(ios(11.0));

#else
#import <WebKit/WKBase.h>
#endif

#if !TARGET_OS_IPHONE

typedef NS_ENUM(NSInteger, _WKImmediateActionType) {
    _WKImmediateActionNone,
    _WKImmediateActionLinkPreview,
    _WKImmediateActionDataDetectedItem,
    _WKImmediateActionLookupText,
    _WKImmediateActionMailtoLink,
    _WKImmediateActionTelLink
} API_AVAILABLE(macos(10.12));

typedef NS_OPTIONS(NSUInteger, _WKRectEdge) {
    _WKRectEdgeNone = 0,
    _WKRectEdgeLeft = 1 << CGRectMinXEdge,
    _WKRectEdgeTop = 1 << CGRectMinYEdge,
    _WKRectEdgeRight = 1 << CGRectMaxXEdge,
    _WKRectEdgeBottom = 1 << CGRectMaxYEdge,
    _WKRectEdgeAll = _WKRectEdgeLeft | _WKRectEdgeTop | _WKRectEdgeRight | _WKRectEdgeBottom,
} API_AVAILABLE(macos(10.13.4));

#endif

@class UIEventAttribution;
@class WKBrowsingContextHandle;
@class WKDownload;
@class WKFrameInfo;
@class WKWebpagePreferences;
@class _WKApplicationManifest;
@class _WKFrameHandle;
@class _WKFrameTreeNode;
@class _WKHitTestResult;
@class _WKInspector;
@class _WKRemoteObjectRegistry;
@class _WKSafeBrowsingWarning;
@class _WKSessionState;
@class _WKTextInputContext;
@class _WKTextManipulationConfiguration;
@class _WKTextManipulationItem;
@class _WKThumbnailView;
@class _WKWebViewPrintFormatter;

@protocol WKHistoryDelegatePrivate;
@protocol _WKAppHighlightDelegate;
@protocol _WKDiagnosticLoggingDelegate;
@protocol _WKFindDelegate;
@protocol _WKFullscreenDelegate;
@protocol _WKIconLoadingDelegate;
@protocol _WKInputDelegate;
@protocol _WKResourceLoadDelegate;
@protocol _WKTextManipulationDelegate;

@interface WKWebView (WKPrivate)

// FIXME: This should return a _WKRemoteObjectRegistry *.
@property (nonatomic, readonly) id _remoteObjectRegistry;
@property (nonatomic, readonly) WKBrowsingContextHandle *_handle;

@property (nonatomic, setter=_setObservedRenderingProgressEvents:) _WKRenderingProgressEvents _observedRenderingProgressEvents;

@property (nonatomic, weak, setter=_setHistoryDelegate:) id <WKHistoryDelegatePrivate> _historyDelegate;
@property (nonatomic, weak, setter=_setIconLoadingDelegate:) id <_WKIconLoadingDelegate> _iconLoadingDelegate;
@property (nonatomic, weak, setter=_setResourceLoadDelegate:) id <_WKResourceLoadDelegate> _resourceLoadDelegate API_AVAILABLE(macos(11.0), ios(14.0));

@property (nonatomic, readonly) NSURL *_unreachableURL;
@property (nonatomic, readonly) NSURL *_mainFrameURL API_AVAILABLE(macos(10.15), ios(13.0));
@property (nonatomic, readonly) NSURL *_resourceDirectoryURL API_AVAILABLE(macos(10.15), ios(13.0));

- (void)_loadAlternateHTMLString:(NSString *)string baseURL:(NSURL *)baseURL forUnreachableURL:(NSURL *)unreachableURL;
- (WKNavigation *)_loadData:(NSData *)data MIMEType:(NSString *)MIMEType characterEncodingName:(NSString *)characterEncodingName baseURL:(NSURL *)baseURL userData:(id)userData API_AVAILABLE(macos(10.12), ios(10.0));
- (WKNavigation *)_loadRequest:(NSURLRequest *)request shouldOpenExternalURLs:(BOOL)shouldOpenExternalURLs API_AVAILABLE(macos(10.13), ios(11.0));
- (WKNavigation *)_loadRequest:(NSURLRequest *)request shouldOpenExternalURLsPolicy:(_WKShouldOpenExternalURLsPolicy)shouldOpenExternalURLsPolicy API_AVAILABLE(macos(12.0), ios(15.0));

@property (nonatomic, readonly) NSArray *_certificateChain API_DEPRECATED_WITH_REPLACEMENT("certificateChain", macos(10.10, 10.11), ios(8.0, 9.0));
@property (nonatomic, readonly) NSURL *_committedURL;
@property (nonatomic, readonly) NSString *_MIMEType;
@property (nonatomic, readonly) NSString *_userAgent API_AVAILABLE(macos(10.11), ios(9.0));
@property (copy, setter=_setApplicationNameForUserAgent:) NSString *_applicationNameForUserAgent;
@property (copy, setter=_setCustomUserAgent:) NSString *_customUserAgent;

@property (nonatomic, readonly, getter=_isPlayingAudio) BOOL _playingAudio API_AVAILABLE(macos(10.13.4), ios(11.3));
@property (nonatomic, setter=_setUserContentExtensionsEnabled:) BOOL _userContentExtensionsEnabled API_AVAILABLE(macos(10.11), ios(9.0));

@property (nonatomic, readonly) pid_t _webProcessIdentifier;
@property (nonatomic, readonly) pid_t _provisionalWebProcessIdentifier API_AVAILABLE(macos(10.14.4), ios(12.2));

@property (nonatomic, getter=_isEditable, setter=_setEditable:) BOOL _editable API_AVAILABLE(macos(10.11), ios(9.0));

/*! @abstract A Boolean value indicating whether any resource on the page
has been loaded over a connection using TLS 1.0 or TLS 1.1.
@discussion @link WKWebView @/link is key-value observing (KVO) compliant
for this property.
*/
@property (nonatomic, readonly) BOOL _negotiatedLegacyTLS API_AVAILABLE(macos(10.15.4), ios(13.4));

- (void)_frames:(void (^)(_WKFrameTreeNode *))completionHandler API_AVAILABLE(macos(11.0), ios(14.0));

// FIXME: Remove these once nobody is using them.
@property (nonatomic, readonly) NSData *_sessionStateData;
- (void)_restoreFromSessionStateData:(NSData *)sessionStateData;

@property (nonatomic, readonly) _WKSessionState *_sessionState;
- (WKNavigation *)_restoreSessionState:(_WKSessionState *)sessionState andNavigate:(BOOL)navigate;
- (_WKSessionState *)_sessionStateWithFilter:(BOOL (^)(WKBackForwardListItem *item))filter;

@property (nonatomic, setter=_setAllowsRemoteInspection:) BOOL _allowsRemoteInspection;
@property (nonatomic, copy, setter=_setRemoteInspectionNameOverride:) NSString *_remoteInspectionNameOverride API_AVAILABLE(macos(10.12), ios(10.0));
@property (nonatomic, readonly) BOOL _isBeingInspected API_AVAILABLE(macos(12.0), ios(15.0));
@property (nonatomic, readonly) _WKInspector *_inspector API_AVAILABLE(macos(10.14.4), ios(12.2));

@property (nonatomic, readonly) _WKFrameHandle *_mainFrame API_AVAILABLE(macos(10.14.4), ios(12.2));

@property (nonatomic, weak, setter=_setTextManipulationDelegate:) id <_WKTextManipulationDelegate> _textManipulationDelegate API_AVAILABLE(macos(10.15.4), ios(13.4));
- (void)_startTextManipulationsWithConfiguration:(_WKTextManipulationConfiguration *)configuration completion:(void(^)(void))completionHandler API_AVAILABLE(macos(10.15.4), ios(13.4));
- (void)_completeTextManipulation:(_WKTextManipulationItem *)item completion:(void(^)(BOOL success))completionHandler API_AVAILABLE(macos(10.15.4), ios(13.4));
- (void)_completeTextManipulationForItems:(NSArray<_WKTextManipulationItem *> *)items completion:(void(^)(NSArray<NSError *> *errors))completionHandler API_AVAILABLE(macos(11.0), ios(14.0));

@property (nonatomic, setter=_setAddsVisitedLinks:) BOOL _addsVisitedLinks;

@property (nonatomic, readonly) BOOL _networkRequestsInProgress;

@property (nonatomic, readonly, getter=_isShowingNavigationGestureSnapshot) BOOL _showingNavigationGestureSnapshot;

- (void)_close;
- (BOOL)_tryClose API_AVAILABLE(macos(10.15.4), ios(13.4));
- (BOOL)_isClosed API_AVAILABLE(macos(10.15.4), ios(13.4));

- (void)_updateWebpagePreferences:(WKWebpagePreferences *)webpagePreferences API_AVAILABLE(macos(10.15.4), ios(13.4));
- (void)_notifyUserScripts API_AVAILABLE(macos(11.0), ios(14.0));
@property (nonatomic, readonly) BOOL _deferrableUserScriptsNeedNotification API_AVAILABLE(macos(11.0), ios(14.0));

- (void)_evaluateJavaScriptWithoutUserGesture:(NSString *)javaScriptString completionHandler:(void (^)(id, NSError *))completionHandler API_AVAILABLE(macos(10.13), ios(11.0));
- (void)_evaluateJavaScript:(NSString *)javaScriptString inFrame:(WKFrameInfo *)frame inContentWorld:(WKContentWorld *)contentWorld completionHandler:(void (^)(id, NSError * error))completionHandler API_AVAILABLE(macos(11.0), ios(14.0));
- (void)_evaluateJavaScript:(NSString *)javaScriptString withSourceURL:(NSURL *)sourceURL inFrame:(WKFrameInfo *)frame inContentWorld:(WKContentWorld *)contentWorld completionHandler:(void (^)(id, NSError * error))completionHandler API_AVAILABLE(macos(11.0), ios(14.0));
- (void)_callAsyncJavaScript:(NSString *)functionBody arguments:(NSDictionary<NSString *, id> *)arguments inFrame:(WKFrameInfo *)frame inContentWorld:(WKContentWorld *)contentWorld completionHandler:(void (^)(id, NSError *error))completionHandler API_AVAILABLE(macos(11.0), ios(14.0));

- (BOOL)_allMediaPresentationsClosed API_AVAILABLE(macos(12.0), ios(15.0));

@property (nonatomic, setter=_setLayoutMode:) _WKLayoutMode _layoutMode;
// For use with _layoutMode = _WKLayoutModeFixedSize:
@property (nonatomic, setter=_setFixedLayoutSize:) CGSize _fixedLayoutSize;

@property (nonatomic, setter=_setViewportSizeForCSSViewportUnits:) CGSize _viewportSizeForCSSViewportUnits API_AVAILABLE(macos(10.13), ios(11.0));

@property (nonatomic, setter=_setViewScale:) CGFloat _viewScale API_AVAILABLE(macos(10.11), ios(9.0));

@property (nonatomic, copy, setter=_setCORSDisablingPatterns:) NSArray<NSString *> *_corsDisablingPatterns API_AVAILABLE(macos(11.0), ios(14.0));

@property (nonatomic, setter=_setMinimumEffectiveDeviceWidth:) CGFloat _minimumEffectiveDeviceWidth API_AVAILABLE(macos(10.14.4), ios(12.2));

@property (nonatomic, setter=_setBackgroundExtendsBeyondPage:) BOOL _backgroundExtendsBeyondPage API_AVAILABLE(macos(10.13.4), ios(8.0));

- (_WKAttachment *)_insertAttachmentWithFilename:(NSString *)filename contentType:(NSString *)contentType data:(NSData *)data options:(_WKAttachmentDisplayOptions *)options completion:(void(^)(BOOL success))completionHandler API_DEPRECATED_WITH_REPLACEMENT("-_insertAttachmentWithFileWrapper:contentType:options:completion:", macos(10.13.4, 10.14.4), ios(11.3, 12.2));
- (_WKAttachment *)_insertAttachmentWithFileWrapper:(NSFileWrapper *)fileWrapper contentType:(NSString *)contentType options:(_WKAttachmentDisplayOptions *)options completion:(void(^)(BOOL success))completionHandler API_DEPRECATED_WITH_REPLACEMENT("-_insertAttachmentWithFileWrapper:contentType:completion:", macos(10.14.4, 10.14.4), ios(12.2, 12.2));
- (_WKAttachment *)_insertAttachmentWithFileWrapper:(NSFileWrapper *)fileWrapper contentType:(NSString *)contentType completion:(void(^)(BOOL success))completionHandler API_AVAILABLE(macos(10.14.4), ios(12.2));
- (_WKAttachment *)_attachmentForIdentifier:(NSString *)identifier API_AVAILABLE(macos(10.14.4), ios(12.2));

- (void)_simulateDeviceOrientationChangeWithAlpha:(double)alpha beta:(double)beta gamma:(double)gamma API_AVAILABLE(macos(10.14.4), ios(12.2));

+ (BOOL)_willUpgradeToHTTPS:(NSURL *)url API_AVAILABLE(macos(12.0), ios(15.0));

+ (BOOL)_handlesSafeBrowsing API_AVAILABLE(macos(10.14.4), ios(12.2));
+ (NSURL *)_confirmMalwareSentinel API_AVAILABLE(macos(10.14.4), ios(12.2));
+ (NSURL *)_visitUnsafeWebsiteSentinel API_AVAILABLE(macos(10.14.4), ios(12.2));
- (void)_showSafeBrowsingWarningWithTitle:(NSString *)title warning:(NSString *)warning details:(NSAttributedString *)details completionHandler:(void(^)(BOOL))completionHandler API_DEPRECATED_WITH_REPLACEMENT("-_showSafeBrowsingWarningWithURL:title:warning:detailsWithLinks:completionHandler:", macos(10.14.4, 10.15.4), ios(12.2, 13.2));
- (void)_showSafeBrowsingWarningWithURL:(NSURL *)url title:(NSString *)title warning:(NSString *)warning details:(NSAttributedString *)details completionHandler:(void(^)(BOOL))completionHandler API_DEPRECATED_WITH_REPLACEMENT("-_showSafeBrowsingWarningWithURL:title:warning:detailsWithLinks:completionHandler:", macos(10.14.4, 10.15.4), ios(12.2, 13.2));
- (void)_showSafeBrowsingWarningWithURL:(NSURL *)url title:(NSString *)title warning:(NSString *)warning detailsWithLinks:(NSAttributedString *)details completionHandler:(void(^)(BOOL, NSURL *))completionHandler API_AVAILABLE(macos(10.15.4), ios(13.2));

- (void)_doAfterNextPresentationUpdate:(void (^)(void))updateBlock API_AVAILABLE(macos(10.12), ios(10.0));
- (void)_doAfterNextPresentationUpdateWithoutWaitingForPainting:(void (^)(void))updateBlock API_AVAILABLE(macos(10.12.3), ios(10.3));

- (void)_executeEditCommand:(NSString *)command argument:(NSString *)argument completion:(void (^)(BOOL))completion API_AVAILABLE(macos(10.13.4), ios(11.3));

- (void)_isJITEnabled:(void(^)(BOOL))completionHandler API_AVAILABLE(macos(10.14.4), ios(12.2));
- (void)_removeDataDetectedLinks:(dispatch_block_t)completion API_AVAILABLE(macos(10.14.4), ios(12.2));

- (IBAction)_alignCenter:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_alignJustified:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_alignLeft:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_alignRight:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_indent:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_outdent:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_toggleStrikeThrough:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_insertOrderedList:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_insertUnorderedList:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_insertNestedOrderedList:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_insertNestedUnorderedList:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_increaseListLevel:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_decreaseListLevel:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_changeListType:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_pasteAsQuotation:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_pasteAndMatchStyle:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));
- (IBAction)_takeFindStringFromSelection:(id)sender API_AVAILABLE(macos(10.14.4), ios(12.2));

@property (class, nonatomic, copy, setter=_setStringForFind:) NSString *_stringForFind API_AVAILABLE(macos(10.14.4), ios(12.2));
@property (nonatomic, readonly) _WKSelectionAttributes _selectionAttributes API_AVAILABLE(macos(10.15), ios(13.0));

- (WKNavigation *)_reloadWithoutContentBlockers API_AVAILABLE(macos(10.12), ios(10.0));
- (WKNavigation *)_reloadExpiredOnly API_AVAILABLE(macos(10.13), ios(11.0));

@property (nonatomic, readonly) BOOL _webProcessIsResponsive API_AVAILABLE(macos(10.12), ios(10.0));
- (void)_killWebContentProcess;
- (void)_killWebContentProcessAndResetState;

- (void)_getMainResourceDataWithCompletionHandler:(void (^)(NSData *, NSError *))completionHandler;
- (void)_getWebArchiveDataWithCompletionHandler:(void (^)(NSData *, NSError *))completionHandler;
- (void)_getContentsAsStringWithCompletionHandler:(void (^)(NSString *, NSError *))completionHandler API_AVAILABLE(macos(10.13), ios(11.0));
- (void)_getContentsAsStringWithCompletionHandlerKeepIPCConnectionAliveForTesting:(void (^)(NSString *, NSError *))completionHandler;
- (void)_getContentsOfAllFramesAsStringWithCompletionHandler:(void (^)(NSString *))completionHandler API_AVAILABLE(macos(11.0), ios(14.0));
- (void)_getContentsAsAttributedStringWithCompletionHandler:(void (^)(NSAttributedString *, NSDictionary<NSAttributedStringDocumentAttributeKey, id> *, NSError *))completionHandler API_AVAILABLE(macos(10.15), ios(13.0));

- (void)_getApplicationManifestWithCompletionHandler:(void (^)(_WKApplicationManifest *))completionHandler API_AVAILABLE(macos(10.13.4), ios(11.3));

@property (nonatomic, setter=_setPaginationMode:) _WKPaginationMode _paginationMode;
// Whether the column-break-{before,after} properties are respected instead of the
// page-break-{before,after} properties.
@property (nonatomic, setter=_setPaginationBehavesLikeColumns:) BOOL _paginationBehavesLikeColumns;
// Set to 0 to have the page length equal the view length.
@property (nonatomic, setter=_setPageLength:) CGFloat _pageLength;
@property (nonatomic, setter=_setGapBetweenPages:) CGFloat _gapBetweenPages;
@property (nonatomic, setter=_setPaginationLineGridEnabled:) BOOL _paginationLineGridEnabled;
@property (readonly) NSUInteger _pageCount;

@property (nonatomic, readonly) BOOL _supportsTextZoom;
@property (nonatomic, setter=_setTextZoomFactor:) double _textZoomFactor;
@property (nonatomic, setter=_setPageZoomFactor:) double _pageZoomFactor;

@property (nonatomic, weak, setter=_setDiagnosticLoggingDelegate:) id <_WKDiagnosticLoggingDelegate> _diagnosticLoggingDelegate API_AVAILABLE(macos(10.11), ios(9.0));
@property (nonatomic, weak, setter=_setFindDelegate:) id <_WKFindDelegate> _findDelegate;
- (void)_findString:(NSString *)string options:(_WKFindOptions)options maxCount:(NSUInteger)maxCount;
- (void)_countStringMatches:(NSString *)string options:(_WKFindOptions)options maxCount:(NSUInteger)maxCount;
- (void)_hideFindUI;

@property (nonatomic, weak, setter=_setInputDelegate:) id <_WKInputDelegate> _inputDelegate API_AVAILABLE(macos(10.12), ios(10.0));

@property (nonatomic, readonly, getter=_isDisplayingStandaloneImageDocument) BOOL _displayingStandaloneImageDocument;
@property (nonatomic, readonly, getter=_isDisplayingStandaloneMediaDocument) BOOL _displayingStandaloneMediaDocument;

@property (nonatomic, setter=_setScrollPerformanceDataCollectionEnabled:) BOOL _scrollPerformanceDataCollectionEnabled API_AVAILABLE(macos(10.11), ios(9.0));
@property (nonatomic, readonly) NSArray *_scrollPerformanceData API_AVAILABLE(macos(10.11), ios(9.0));

- (void)_saveBackForwardSnapshotForItem:(WKBackForwardListItem *)item API_AVAILABLE(macos(10.11), ios(9.0));

@property (nonatomic, getter=_allowsMediaDocumentInlinePlayback, setter=_setAllowsMediaDocumentInlinePlayback:) BOOL _allowsMediaDocumentInlinePlayback;

@property (nonatomic, setter=_setFullscreenDelegate:) id<_WKFullscreenDelegate> _fullscreenDelegate API_AVAILABLE(macos(10.13), ios(11.0));
@property (nonatomic, readonly) BOOL _isInFullscreen API_AVAILABLE(macos(10.12.3));

@property (nonatomic, readonly) _WKMediaCaptureStateDeprecated _mediaCaptureState API_AVAILABLE(macos(10.15), ios(13.0));
@property (nonatomic, readonly) _WKMediaMutedState _mediaMutedState API_AVAILABLE(macos(11.0), ios(14.0));

- (void)_setPageMuted:(_WKMediaMutedState)mutedState API_AVAILABLE(macos(10.13), ios(11.0));

@property (nonatomic, setter=_setMediaCaptureEnabled:) BOOL _mediaCaptureEnabled API_AVAILABLE(macos(10.13), ios(11.0));
- (void)_stopMediaCapture API_AVAILABLE(macos(10.15.4), ios(13.4));

@property (nonatomic, readonly) BOOL _canTogglePictureInPicture;
@property (nonatomic, readonly) BOOL _isPictureInPictureActive;
- (void)_updateMediaPlaybackControlsManager;
- (void)_togglePictureInPicture;
- (void)_stopAllMediaPlayback;
- (void)_suspendAllMediaPlayback;
- (void)_resumeAllMediaPlayback;
- (void)_closeAllMediaPresentations;

- (void)_takePDFSnapshotWithConfiguration:(WKSnapshotConfiguration *)snapshotConfiguration completionHandler:(void (^)(NSData *pdfSnapshotData, NSError *error))completionHandler API_AVAILABLE(macos(10.15.4), ios(13.4));
- (void)_getPDFFirstPageSizeInFrame:(_WKFrameHandle *)frame completionHandler:(void(^)(CGSize))completionHandler API_AVAILABLE(macos(12.0), ios(15.0));

- (void)_getProcessDisplayNameWithCompletionHandler:(void (^)(NSString *))completionHandler API_AVAILABLE(macos(11.0), ios(14.0));

- (void)_grantAccessToPreferenceService API_AVAILABLE(macos(11.0), ios(14.0));

- (void)_serviceWorkersEnabled:(void(^)(BOOL))completionHandler API_AVAILABLE(macos(11.0), ios(14.0));
- (void)_clearServiceWorkerEntitlementOverride:(void (^)(void))completionHandler API_AVAILABLE(macos(11.0), ios(14.0));

- (void)_preconnectToServer:(NSURL *)serverURL API_AVAILABLE(macos(11.0), ios(14.0));

@property (nonatomic, setter=_setCanUseCredentialStorage:) BOOL _canUseCredentialStorage API_AVAILABLE(macos(12.0), ios(15.0));

- (void)_didEnableBrowserExtensions:(NSDictionary<NSString *, NSString *> *)extensionIDToNameMap API_AVAILABLE(macos(12.0), ios(15.0));
- (void)_didDisableBrowserExtensions:(NSSet<NSString *> *)extensionIDs API_AVAILABLE(macos(12.0), ios(15.0));

@property (nonatomic, weak, setter=_setAppHighlightDelegate:) id <_WKAppHighlightDelegate> _appHighlightDelegate API_AVAILABLE(macos(12.0), ios(15.0));
- (void)_restoreAppHighlights:(NSArray<NSData *> *)highlights API_AVAILABLE(macos(12.0), ios(15.0));
- (void)_restoreAndScrollToAppHighlight:(NSData *)highlight API_AVAILABLE(macos(12.0), ios(15.0));
- (void)_addAppHighlight API_AVAILABLE(macos(12.0), ios(15.0));
- (void)_addAppHighlightInNewGroup:(BOOL)newGroup originatedInApp:(BOOL)originatedInApp API_AVAILABLE(macos(12.0), ios(15.0));

// FIXME: Remove old `-[WKWebView _themeColor]` SPI <rdar://76662644>
#if TARGET_OS_IPHONE
@property (nonatomic, readonly) UIColor *_themeColor API_DEPRECATED_WITH_REPLACEMENT("themeColor", ios(15.0, 15.0));
#else
@property (nonatomic, readonly) NSColor *_themeColor API_DEPRECATED_WITH_REPLACEMENT("themeColor", macos(12.0, 12.0));
#endif

// FIXME: Remove old `-[WKWebView _pageExtendedBackgroundColor]` SPI <rdar://77789732>
#if TARGET_OS_IPHONE
@property (nonatomic, readonly) UIColor *_pageExtendedBackgroundColor API_DEPRECATED_WITH_REPLACEMENT("underPageBackgroundColor", ios(15.0, 15.0));
#else
@property (nonatomic, readonly) NSColor *_pageExtendedBackgroundColor API_DEPRECATED_WITH_REPLACEMENT("underPageBackgroundColor", macos(10.10, 12.0));
#endif

// Only set if `-[WKWebViewConfiguration _sampledPageTopColorMaxDifference]` is a positive number.
#if TARGET_OS_IPHONE
@property (nonatomic, readonly) UIColor *_sampledPageTopColor API_AVAILABLE(ios(15.0));
#else
@property (nonatomic, readonly) NSColor *_sampledPageTopColor API_AVAILABLE(macos(12.0));
#endif

- (void)_grantAccessToAssetServices API_AVAILABLE(macos(12.0), ios(14.0));
- (void)_revokeAccessToAssetServices API_AVAILABLE(macos(12.0), ios(14.0));

/*! @abstract If the WKWebView was created with _shouldAllowUserInstalledFonts = NO,
 the web process will automatically use an in-process font registry, and its sandbox
 will be restricted to forbid access to fontd. Otherwise, the web process will use
 fontd to look up fonts instead of using the in-process registry, and the web
 process's sandbox will automatically be extended to allow access to fontd. This
 method represents a one-time, web-process-wide switch from using the in-process
 font registry to using fontd, including granting the relevant sandbox extension.
*/
- (void)_switchFromStaticFontRegistryToUserFontRegistry API_AVAILABLE(macos(12.0));

- (void)_didLoadAppInitiatedRequest:(void (^)(BOOL result))completionHandler;
- (void)_didLoadNonAppInitiatedRequest:(void (^)(BOOL result))completionHandler;

- (void)_loadServiceWorker:(NSURL *)url completionHandler:(void (^)(BOOL success))completionHandler API_AVAILABLE(macos(12.0), ios(NA));

- (void)_suspendPage:(void (^)(BOOL))completionHandler API_AVAILABLE(macos(12.0), ios(15.0));
- (void)_resumePage:(void (^)(BOOL))completionHandler API_AVAILABLE(macos(12.0), ios(15.0));

- (void)_startImageAnalysis:(NSString *)identifier API_AVAILABLE(macos(12.0), ios(NA));

- (void)_requestResource:(NSURLRequest *)request completionHandler:(void(^)(NSData *, NSURLResponse *, NSError *))completionHandler API_AVAILABLE(macos(12.0), ios(NA));

@end

#if TARGET_OS_IPHONE

#if __has_include(<UIKit/_UITextSearching.h>)
@interface WKWebView (WKPrivateIOS) <_UITextSearching>
#else
@interface WKWebView (WKPrivateIOS)
#endif

#if !TARGET_OS_TV && !TARGET_OS_WATCH
@property (nonatomic, copy, setter=_setUIEventAttribution:) UIEventAttribution *_uiEventAttribution API_AVAILABLE(ios(15.0));
@property (nonatomic, copy, setter=_setEphemeralUIEventAttribution:) UIEventAttribution *_ephemeralUIEventAttribution API_AVAILABLE(ios(NA));
- (void)_setEphemeralUIEventAttribution:(UIEventAttribution *)attribution forApplicationWithBundleID:(NSString *)bundleID API_AVAILABLE(ios(NA));
#endif

@property (nonatomic, readonly) CGRect _contentVisibleRect API_AVAILABLE(ios(10.0));

// DERECATED: The setters of the three following function are deprecated, please use overrideLayoutParameters.
// Define the smallest size a page take with a regular viewport.
@property (nonatomic, readonly) CGSize _minimumLayoutSizeOverride;
// Define the largest size the unobscured area can get for the current view bounds. This value is used to define viewport units.
@property (nonatomic, readonly) CGSize _maximumUnobscuredSizeOverride;

// Define the inset of the scrollview unusable by the web page.
@property (nonatomic, setter=_setObscuredInsets:) UIEdgeInsets _obscuredInsets;

@property (nonatomic, setter=_setUnobscuredSafeAreaInsets:) UIEdgeInsets _unobscuredSafeAreaInsets API_AVAILABLE(ios(11.0));
@property (nonatomic, readonly) BOOL _safeAreaShouldAffectObscuredInsets API_AVAILABLE(ios(11.0));
@property (nonatomic, setter=_setObscuredInsetEdgesAffectedBySafeArea:) UIRectEdge _obscuredInsetEdgesAffectedBySafeArea API_AVAILABLE(ios(11.0));

// An ancestor view whose bounds will be intersected with those of this WKWebView to determine the visible region of content to render.
@property (nonatomic, readonly) UIView *_enclosingViewForExposedRectComputation API_AVAILABLE(ios(11.0));

// Override the interface orientation. Clients using _beginAnimatedResizeWithUpdates: must update the interface orientation
// in the update block.
@property (nonatomic, setter=_setInterfaceOrientationOverride:) UIInterfaceOrientation _interfaceOrientationOverride;
- (void)_clearInterfaceOrientationOverride API_AVAILABLE(ios(11.0));

@property (nonatomic, setter=_setAllowsViewportShrinkToFit:) BOOL _allowsViewportShrinkToFit;

// FIXME: Remove these three properties once we expose WKWebViewContentProvider as API.
@property (nonatomic, readonly, getter=_isDisplayingPDF) BOOL _displayingPDF;
@property (nonatomic, readonly) NSData *_dataForDisplayedPDF;
// FIXME: This can be removed once WKNavigation's response property is implemented.
@property (nonatomic, readonly) NSString *_suggestedFilenameForDisplayedPDF;

@property (nonatomic, readonly) _WKWebViewPrintFormatter *_webViewPrintFormatter;

@property (nonatomic, setter=_setDragInteractionPolicy:) _WKDragInteractionPolicy _dragInteractionPolicy API_AVAILABLE(ios(11.0));
@property (nonatomic, readonly) BOOL _shouldAvoidResizingWhenInputViewBoundsChange API_AVAILABLE(ios(13.0));
@property (nonatomic, readonly) BOOL _contentViewIsFirstResponder API_AVAILABLE(ios(12.2));

@property (nonatomic, readonly) CGRect _uiTextCaretRect API_AVAILABLE(ios(10.3));

@property (nonatomic, readonly) UIView *_safeBrowsingWarning API_AVAILABLE(macos(10.14.4), ios(12.2));

- (CGPoint)_convertPointFromContentsToView:(CGPoint)point API_AVAILABLE(ios(10.0));
- (CGPoint)_convertPointFromViewToContents:(CGPoint)point API_AVAILABLE(ios(10.0));

- (void)_doAfterNextStablePresentationUpdate:(dispatch_block_t)updateBlock API_AVAILABLE(ios(10.3));

- (void)_setFont:(UIFont *)font sender:(id)sender API_AVAILABLE(ios(12.2));
- (void)_setFontSize:(CGFloat)fontSize sender:(id)sender API_AVAILABLE(ios(12.2));
- (void)_setTextColor:(UIColor *)color sender:(id)sender API_AVAILABLE(ios(12.2));

- (void)_detectDataWithTypes:(WKDataDetectorTypes)types completionHandler:(dispatch_block_t)completion API_AVAILABLE(ios(12.2));

- (void)_requestActivatedElementAtPosition:(CGPoint)position completionBlock:(void (^)(_WKActivatedElementInfo *))block API_AVAILABLE(ios(11.0));

- (void)didStartFormControlInteraction API_AVAILABLE(ios(10.3));
- (void)didEndFormControlInteraction API_AVAILABLE(ios(10.3));

- (void)_beginInteractiveObscuredInsetsChange;
- (void)_endInteractiveObscuredInsetsChange;
- (void)_hideContentUntilNextUpdate;

- (void)_beginAnimatedResizeWithUpdates:(void (^)(void))updateBlock;
- (void)_endAnimatedResize;
- (void)_resizeWhileHidingContentWithUpdates:(void (^)(void))updateBlock;

- (void)_snapshotRectAfterScreenUpdates:(BOOL)afterScreenUpdates rectInViewCoordinates:(CGRect)rectInViewCoordinates intoImageOfWidth:(CGFloat)imageWidth completionHandler:(void(^)(CGImageRef))completionHandler API_AVAILABLE(ios(NA));
- (void)_snapshotRect:(CGRect)rectInViewCoordinates intoImageOfWidth:(CGFloat)imageWidth completionHandler:(void(^)(CGImageRef))completionHandler;

- (void)_overrideLayoutParametersWithMinimumLayoutSize:(CGSize)minimumLayoutSize maximumUnobscuredSizeOverride:(CGSize)maximumUnobscuredSizeOverride API_AVAILABLE(ios(9_0));
- (void)_clearOverrideLayoutParameters API_AVAILABLE(ios(11.0));
- (void)_overrideViewportWithArguments:(NSDictionary<NSString *, NSString *> *)arguments API_AVAILABLE(ios(13.0));

- (UIView *)_viewForFindUI;

- (void)_setOverlaidAccessoryViewsInset:(CGSize)inset;

// Puts the view into a state where being taken out of the view hierarchy and resigning first responder
// will not count as becoming inactive and unfocused. The returned block must be called to exit the state.
- (void (^)(void))_retainActiveFocusedState API_AVAILABLE(ios(9_0));

- (void)_becomeFirstResponderWithSelectionMovingForward:(BOOL)selectingForward completionHandler:(void (^)(BOOL didBecomeFirstResponder))completionHandler API_AVAILABLE(ios(9_0));

- (id)_snapshotLayerContentsForBackForwardListItem:(WKBackForwardListItem *)item API_AVAILABLE(ios(9_0));

- (NSArray *)_dataDetectionResults;

- (void)_accessibilityRetrieveRectsAtSelectionOffset:(NSInteger)offset withText:(NSString *)text completionHandler:(void (^)(NSArray<NSValue *> *rects))completionHandler API_AVAILABLE(ios(11.3));
- (void)_accessibilityStoreSelection API_AVAILABLE(ios(11.3));
- (void)_accessibilityClearSelection API_AVAILABLE(ios(11.3));

- (void)_accessibilityRetrieveSpeakSelectionContent API_AVAILABLE(ios(11.0));
- (void)_accessibilityDidGetSpeakSelectionContent:(NSString *)content API_AVAILABLE(ios(11.0));

- (UIView *)_fullScreenPlaceholderView API_AVAILABLE(ios(12.0));

- (void)_willOpenAppLink API_AVAILABLE(ios(14.0));

- (void)_isNavigatingToAppBoundDomain:(void(^)(BOOL))completionHandler API_AVAILABLE(ios(14.0));
- (void)_isForcedIntoAppBoundMode:(void(^)(BOOL))completionHandler API_AVAILABLE(ios(14.0));

@end

@interface WKWebView () <UIResponderStandardEditActions>
@end

#if !TARGET_OS_WATCH

@interface WKWebView (FullScreenAPI_Private)

-(BOOL)hasFullScreenWindowController;
-(void)closeFullScreenWindowController;

@end
#endif // !TARGET_OS_WATCH

#endif // TARGET_OS_IPHONE


#if !TARGET_OS_IPHONE

@interface WKWebView (WKPrivateMac)

@property (nonatomic, readonly) WKPageRef _pageRefForTransitionToWKWebView  API_AVAILABLE(macos(10.13.4));
@property (nonatomic, readonly) BOOL _hasActiveVideoForControlsManager API_AVAILABLE(macos(10.12));
@property (nonatomic, readwrite, setter=_setIgnoresNonWheelEvents:) BOOL _ignoresNonWheelEvents API_AVAILABLE(macos(10.13.4));

/*! @abstract A Boolean value indicating whether drawing clips to the visibleRect.
@discussion When YES, the view will use its -visibleRect when determining which areas of the WKWebView to draw. This may improve performance for large WKWebViews which are mostly clipped out by enclosing views.  The default value is NO.
*/
@property (nonatomic, readwrite, setter=_setClipsToVisibleRect:) BOOL _clipsToVisibleRect API_AVAILABLE(macos(11.0));

@property (nonatomic, readonly) NSView *_safeBrowsingWarning API_AVAILABLE(macos(10.14.4));

@property (nonatomic, readonly) _WKRectEdge _pinnedState API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setRubberBandingEnabled:) _WKRectEdge _rubberBandingEnabled API_AVAILABLE(macos(10.13.4));

@property (nonatomic, setter=_setBackgroundColor:) NSColor *_backgroundColor API_AVAILABLE(macos(10.14));
@property (nonatomic, copy, setter=_setUnderlayColor:) NSColor *_underlayColor API_AVAILABLE(macos(10.13.4));

@property (nonatomic, setter=_setTotalHeightOfBanners:) CGFloat _totalHeightOfBanners API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setDrawsBackground:) BOOL _drawsBackground;
@property (nonatomic, setter=_setTopContentInset:) CGFloat _topContentInset;

@property (nonatomic, setter=_setAutomaticallyAdjustsContentInsets:) BOOL _automaticallyAdjustsContentInsets;

// Default value is 0. A value of 0 means the window's backing scale factor will be used and automatically update when the window moves screens.
@property (nonatomic, setter=_setOverrideDeviceScaleFactor:) CGFloat _overrideDeviceScaleFactor API_AVAILABLE(macos(10.11));

@property (nonatomic, setter=_setWindowOcclusionDetectionEnabled:) BOOL _windowOcclusionDetectionEnabled;

@property (nonatomic, readonly) NSInteger _spellCheckerDocumentTag API_AVAILABLE(macos(10.14));

// When using _minimumLayoutWidth, the web content will lay out to the intrinsic height
// of the content; use this property to force it to lay out to the height of the view instead.
@property (nonatomic, setter=_setShouldExpandContentToViewHeightForAutoLayout:) BOOL _shouldExpandContentToViewHeightForAutoLayout API_AVAILABLE(macos(10.12));

@property (nonatomic, setter=_setMinimumLayoutWidth:) CGFloat _minimumLayoutWidth API_AVAILABLE(macos(10.12));
@property (nonatomic, setter=_setSizeToContentAutoSizeMaximumSize:) CGSize _sizeToContentAutoSizeMaximumSize;

@property (nonatomic, setter=_setAlwaysShowsHorizontalScroller:) BOOL _alwaysShowsHorizontalScroller API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setAlwaysShowsVerticalScroller:) BOOL _alwaysShowsVerticalScroller API_AVAILABLE(macos(10.13.4));

@property (nonatomic, readwrite, setter=_setUseSystemAppearance:) BOOL _useSystemAppearance API_AVAILABLE(macos(10.14));
@property (nonatomic, setter=_setOverlayScrollbarStyle:) _WKOverlayScrollbarStyle _overlayScrollbarStyle API_AVAILABLE(macos(10.13.4));
@property (strong, nonatomic, setter=_setInspectorAttachmentView:) NSView *_inspectorAttachmentView API_AVAILABLE(macos(10.13.4));

@property (nonatomic, setter=_setThumbnailView:) _WKThumbnailView *_thumbnailView API_AVAILABLE(macos(10.13.4));
@property (nonatomic, setter=_setIgnoresAllEvents:) BOOL _ignoresAllEvents API_AVAILABLE(macos(10.13.4));

// Defaults to YES; if set to NO, WebKit will draw the grey wash and highlights itself.
@property (nonatomic, setter=_setUsePlatformFindUI:) BOOL _usePlatformFindUI API_AVAILABLE(macos(10.15));

- (void)_setShouldSuppressFirstResponderChanges:(BOOL)shouldSuppress;
- (BOOL)_canChangeFrameLayout:(_WKFrameHandle *)frameHandle API_AVAILABLE(macos(10.13.4));
- (BOOL)_tryToSwipeWithEvent:(NSEvent *)event ignoringPinnedState:(BOOL)ignoringPinnedState API_AVAILABLE(macos(10.13.4));

- (void)_dismissContentRelativeChildWindows API_AVAILABLE(macos(10.13.4));
- (void)_setFrame:(NSRect)rect andScrollBy:(NSSize)offset API_AVAILABLE(macos(10.13.4));

- (void)_gestureEventWasNotHandledByWebCore:(NSEvent *)event API_AVAILABLE(macos(10.13.4));

- (void)_disableFrameSizeUpdates API_AVAILABLE(macos(10.13.4));
- (void)_enableFrameSizeUpdates API_AVAILABLE(macos(10.13.4));

- (void)_beginDeferringViewInWindowChanges API_AVAILABLE(macos(10.13.4));
- (void)_endDeferringViewInWindowChanges API_AVAILABLE(macos(10.13.4));
- (void)_endDeferringViewInWindowChangesSync API_AVAILABLE(macos(10.13.4));

- (void)_setCustomSwipeViews:(NSArray *)customSwipeViews API_AVAILABLE(macos(10.13.4));
- (void)_setDidMoveSwipeSnapshotCallback:(void(^)(CGRect))callback API_AVAILABLE(macos(10.13.4));
- (void)_setCustomSwipeViewsTopContentInset:(float)topContentInset API_AVAILABLE(macos(10.13.4));

- (NSView *)_fullScreenPlaceholderView API_AVAILABLE(macos(10.13.4));
- (NSWindow *)_fullScreenWindow API_AVAILABLE(macos(10.13.4));

// Clients that want to maintain default behavior can return nil. To disable the immediate action entirely, return NSNull. And to
// do something custom, return an object that conforms to the NSImmediateActionAnimationController protocol.
- (id)_immediateActionAnimationControllerForHitTestResult:(_WKHitTestResult *)hitTestResult withType:(_WKImmediateActionType)type userData:(id<NSSecureCoding>)userData;

- (NSPrintOperation *)_printOperationWithPrintInfo:(NSPrintInfo *)printInfo;
- (NSPrintOperation *)_printOperationWithPrintInfo:(NSPrintInfo *)printInfo forFrame:(_WKFrameHandle *)frameHandle API_AVAILABLE(macos(10.12));

// FIXME: This SPI should become a part of the WKUIDelegate. rdar://problem/26561537
@property (nonatomic, readwrite, setter=_setWantsMediaPlaybackControlsView:) BOOL _wantsMediaPlaybackControlsView API_AVAILABLE(macos(10.12.3));
@property (nonatomic, readonly) id _mediaPlaybackControlsView API_AVAILABLE(macos(10.13));

- (void)_addMediaPlaybackControlsView:(id)mediaPlaybackControlsView API_AVAILABLE(macos(10.13));
- (void)_removeMediaPlaybackControlsView API_AVAILABLE(macos(10.12.3));

- (void)_prepareForMoveToWindow:(NSWindow *)targetWindow completionHandler:(void(^)(void))completionHandler API_AVAILABLE(macos(10.13));

@end

#endif // !TARGET_OS_IPHONE
