/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Color;
import org.pentaho.reporting.libraries.pixie.wmf.GDIColor;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdSetTextColor
extends MfCmd {
    private static final int RECORD_SIZE = 2;
    private static final int POS_COLOR = 0;
    private Color color;

    public void replay(WmfFile file) {
        MfDcState state = file.getCurrentState();
        state.setTextColor(this.color);
    }

    public MfCmd getInstance() {
        return new MfCmdSetTextColor();
    }

    public void setRecord(MfRecord record) {
        int colref = record.getLongParam(0);
        this.setColor(new GDIColor(colref));
    }

    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(2);
        record.setLongParam(0, GDIColor.translateColor(this.getColor()));
        return record;
    }

    public int getFunction() {
        return 521;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[SET_TEXT_COLOR] textColor=");
        b.append(this.getColor());
        return b.toString();
    }

    protected void scaleXChanged() {
    }

    protected void scaleYChanged() {
    }
}

